/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.inventories;

import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.sculmix.playerprofile.CustomAnvilContainer;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.Slot;
import ru.sculmix.playerprofile.inventories.handlers.IMenuHandler;

public abstract class Menu<T extends Inventory>
implements IMenuHandler<T> {
    protected T inventory;
    protected String title;
    protected final Map<Integer, Slot> slots;
    protected UUID uniqueId;
    protected boolean isDefault;
    protected final String permission;
    protected Player viewer;
    protected PlayerData owner;

    public Menu(String title, Map<Integer, Slot> slots, String permission, boolean isDefault) {
        this.title = title;
        this.slots = slots;
        this.isDefault = isDefault;
        this.permission = permission;
    }

    @Override
    public abstract T create(PlayerProfile var1, PlayerData var2, Player var3);

    public abstract Menu<T> getClone();

    public void update() {
        this.setItems();
    }

    public void setItems() {
        for (Slot slot : this.getSlots().values()) {
            if (!slot.hasPermission(this.viewer)) continue;
            ItemStack item = this.modify(this.owner, slot);
            if (item != null && !item.getType().isAir()) {
                this.inventory.setItem(slot.getNumber(), item);
                continue;
            }
            this.inventory.setItem(slot.getNumber(), slot.getItemPlaceholders(this.owner, this.viewer));
        }
    }

    public ItemStack modify(PlayerData playerData, Slot slot) {
        if (slot.isDefault()) {
            return null;
        }
        PlayerProfile plugin = PlayerProfile.getInstance();
        if (playerData == null) {
            return new ItemStack(Material.AIR);
        }
        OfflinePlayer player = playerData.getOfflinePlayer();
        if (playerData.isOnline()) {
            Player p = player.getPlayer();
            if (plugin.existECosmetics()) {
                switch (slot.getSlotType()) {
                    case HAT: {
                        return plugin.getECosmetics().getHat(player);
                    }
                    case BACKPACK: {
                        return plugin.getECosmetics().getBackPack(player);
                    }
                    case OFF_HAND: {
                        return plugin.getECosmetics().getOffHand(player);
                    }
                    case BALLOON: {
                        return plugin.getECosmetics().getBalloon(player);
                    }
                    case SPRAY: {
                        return plugin.getECosmetics().getSpray(player);
                    }
                    case HELMET: {
                        return plugin.getECosmetics().getHelmet(player);
                    }
                    case SAVED_ITEM: {
                        return playerData.getItemsSaved().get(slot.getNumber());
                    }
                }
            }
            switch (slot.getSlotType()) {
                case HELMET: {
                    return p.getEquipment().getHelmet();
                }
                case CHEST_PLATE: {
                    return p.getEquipment().getChestplate();
                }
                case LEGGINGS: {
                    return p.getEquipment().getLeggings();
                }
                case BOOTS: {
                    return p.getEquipment().getBoots();
                }
                case SAVED_ITEM: {
                    return playerData.getItemsSaved().get(slot.getNumber());
                }
            }
            return new ItemStack(Material.AIR);
        }
        switch (slot.getSlotType()) {
            case HAT: {
                return playerData.getEquipment().getHat();
            }
            case BACKPACK: {
                return playerData.getEquipment().getBackpack();
            }
            case OFF_HAND: {
                return playerData.getEquipment().getOffhand();
            }
            case BALLOON: {
                return playerData.getEquipment().getBalloon();
            }
            case SPRAY: {
                return playerData.getEquipment().getSpray();
            }
            case HELMET: {
                return playerData.getEquipment().getHelmet();
            }
            case CHEST_PLATE: {
                return playerData.getEquipment().getChestPlate();
            }
            case LEGGINGS: {
                return playerData.getEquipment().getLeggings();
            }
            case BOOTS: {
                return playerData.getEquipment().getBoots();
            }
            case SAVED_ITEM: {
                return playerData.getItemsSaved().get(slot.getNumber());
            }
        }
        return new ItemStack(Material.AIR);
    }

    @Override
    public abstract void onClick(InventoryClickEvent var1);

    public String getTitle() {
        return this.title;
    }

    public void titlePlaceholders(Player player) {
        PlayerProfile playerProfile = PlayerProfile.getInstance();
        this.title = this.title.replace("%owner%", this.getOfflinePlayer().getName()).replace("%viewer%", player.getName());
        if (!playerProfile.existPlaceholderAPI()) {
            return;
        }
        this.title = playerProfile.getPlaceholderAPI().setPlaceholders(this.getOfflinePlayer(), this.title);
    }

    public Slot getSlot(int slot) {
        return this.slots.get(slot);
    }

    public Map<Integer, Slot> getSlots() {
        return this.slots;
    }

    public void setInventory(T inventory) {
        this.inventory = inventory;
    }

    public T getInventory() {
        return this.inventory;
    }

    @Override
    public CustomAnvilContainer getCustomAnvilContainer() {
        if (this.inventory instanceof CustomAnvilContainer) {
            return (CustomAnvilContainer)this.inventory;
        }
        return null;
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uniqueId);
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getPermission() {
        return this.permission;
    }
}

