/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.inventories;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.files.FileCreator;
import ru.sculmix.playerprofile.inventories.ActionExecutorType;
import ru.sculmix.playerprofile.inventories.Menu;
import ru.sculmix.playerprofile.inventories.ProfileMenu;
import ru.sculmix.playerprofile.inventories.Slot;
import ru.sculmix.playerprofile.inventories.SlotType;
import ru.sculmix.playerprofile.inventories.handlers.IMenuHandler;
import ru.sculmix.playerprofile.inventories.handlers.StatusMenu;
import ru.sculmix.playerprofile.utils.Utils;

public class MenuLoader {
    private final Map<Inventory, IMenuHandler<?>> activeInventories = new HashMap();
    private static final Map<String, Menu<?>> menuMap = new LinkedHashMap();
    private StatusMenu statusMenu;
    private final PlayerProfile plugin = PlayerProfile.getInstance();

    public MenuLoader() {
        this.loadStatusMenu();
        this.load();
    }

    public void loadStatusMenu() {
        this.activeInventories.put(null, new ProfileMenu("", 5, new HashMap<Integer, Slot>(), "", false));
        this.statusMenu = null;
        FileCreator status = this.plugin.getStatus();
        if (!status.contains("menu")) {
            this.plugin.getLogger().warning("The status menu has not been loaded because the path is not found!");
            return;
        }
        String title = status.getString("menu.title");
        if (this.plugin.existItemsAdder()) {
            title = this.plugin.getItemsAdder().replaceFontImages(title);
        } else if (this.plugin.existNexo()) {
            title = this.plugin.getNexo().replaceFontImages(title);
        }
        if (status.getConfigurationSection("menu.items") == null) {
            this.plugin.getLogger().warning("Status menu configuration is missing 'menu.items' section.");
            return;
        }
        HashMap<Integer, Slot> slotMap = new HashMap<Integer, Slot>();
        for (String key : status.getConfigurationSection("menu.items").getKeys(false)) {
            String path = "menu.items." + key;
            ItemStack item = this.buildItemStack(status, path, key);
            if (item == null) {
                this.plugin.getLogger().severe("Item '" + key + "' in StatusMenu has no 'material', 'item-adder', or 'nexo' defined.");
                continue;
            }
            String texture = status.getStringWF(path + ".texture");
            if (!texture.isEmpty()) {
                item = Utils.getCustomHead(item, texture);
            }
            SlotType slotType = SlotType.DEFAULT;
            if (status.contains(path + ".type")) {
                try {
                    slotType = SlotType.valueOf(status.getString(path + ".type").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().severe("The " + key + " item type does not exist in StatusMenu.");
                    continue;
                }
            }
            int slot = status.getInt(path + ".slot", 0);
            slotMap.put(slot, new Slot(key, slot, item, null, slotType, !texture.isEmpty(), ActionExecutorType.BOTH, ""));
        }
        this.statusMenu = new StatusMenu(title, slotMap);
        this.plugin.getLogger().info("Successfully loaded the status menu!");
    }

    public void load() {
        menuMap.clear();
        for (FileCreator menus : this.plugin.getMenus().getFiles().values()) {
            this.plugin.getLogger().info("Loading menu from file: " + menus.getFileName());
            String title = "";
            if (menus.contains("title")) {
                title = menus.getString("title");
                if (this.plugin.existItemsAdder()) {
                    title = this.plugin.getItemsAdder().replaceFontImages(title);
                } else if (this.plugin.existNexo()) {
                    title = this.plugin.getNexo().replaceFontImages(title);
                }
            }
            boolean isDefault = menus.getBoolean("default");
            String permission = menus.getString("permission", "");
            int rows = menus.getInt("rows", 4);
            if (menus.getConfigurationSection("icons") == null) {
                this.plugin.getLogger().warning("File " + menus.getFileName() + " has no 'icons' section. Skipping.");
                continue;
            }
            HashMap<String, Slot> slotMap = new HashMap<String, Slot>();
            for (String key : menus.getConfigurationSection("icons").getKeys(false)) {
                String texture;
                ItemStack item;
                String path = "icons." + key;
                ItemStack onlineItem = null;
                ItemStack offlineItem = null;
                SlotType slotType = SlotType.DEFAULT;
                if (menus.contains(path + ".type")) {
                    try {
                        slotType = SlotType.valueOf(menus.getString(path + ".type").toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().severe("The " + key + " icon type does not exist.");
                    }
                }
                if (slotType == SlotType.STATUS) {
                    if (menus.contains(path + ".online")) {
                        onlineItem = this.buildItemStack(menus, path + ".online", key + "(online)");
                    }
                    if (menus.contains(path + ".offline")) {
                        offlineItem = this.buildItemStack(menus, path + ".offline", key + "(offline)");
                    }
                    Object object = offlineItem != null ? offlineItem.clone() : (item = onlineItem != null ? onlineItem.clone() : null);
                    if (item == null) {
                        this.plugin.getLogger().severe("Status icon '" + key + "' must have at least an 'online' or 'offline' section defined.");
                        continue;
                    }
                } else {
                    item = this.buildItemStack(menus, path, key);
                    if (item == null) continue;
                    String texture2 = menus.getStringWF(path + ".texture");
                    if (!texture2.isEmpty()) {
                        item = Utils.getCustomHead(item, texture2);
                    }
                    if (menus.contains(path + ".online")) {
                        onlineItem = this.buildItemStack(menus, path + ".online", key + "(online)");
                        String onlineTexture = menus.getStringWF(path + ".online.texture");
                        if (onlineItem != null && !onlineTexture.isEmpty()) {
                            onlineItem = Utils.getCustomHead(onlineItem, onlineTexture);
                        }
                    }
                    if (menus.contains(path + ".offline")) {
                        offlineItem = this.buildItemStack(menus, path + ".offline", key + "(offline)");
                        String offlineTexture = menus.getStringWF(path + ".offline.texture");
                        if (offlineItem != null && !offlineTexture.isEmpty()) {
                            offlineItem = Utils.getCustomHead(offlineItem, offlineTexture);
                        }
                    }
                }
                String itemPermission = menus.getString(path + ".permission", "");
                List<String> actions = menus.getStringList(path + ".actions");
                ActionExecutorType actionExecutorType = ActionExecutorType.BOTH;
                if (menus.contains(path + ".action-executor")) {
                    try {
                        actionExecutorType = ActionExecutorType.valueOf(menus.getString(path + ".action-executor").toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().severe("The " + key + " icon action executor type does not exist.");
                    }
                }
                slotMap.put(key, new Slot(key, 0, item, onlineItem, offlineItem, actions, slotType, !(texture = menus.getStringWF(path + ".texture")).isEmpty(), actionExecutorType, itemPermission));
            }
            List<String> layout = menus.getStringListWF("layout");
            if (layout.size() != rows) {
                this.plugin.getLogger().warning("Layout size does not match row count in " + menus.getFileName() + ". Skipping layout.");
                continue;
            }
            HashMap<Integer, Slot> slots = new HashMap<Integer, Slot>();
            int row = 1;
            for (String line : layout) {
                if (line.length() > 9) continue;
                for (int i = 0; i < line.length(); ++i) {
                    String id = String.valueOf(line.charAt(i));
                    Slot slot = (Slot)slotMap.get(id);
                    if (slot == null) continue;
                    int num = this.getRealSlot(i, row);
                    slot.setNumber(num);
                    slots.put(num, slot.getClone());
                }
                ++row;
            }
            menuMap.put(menus.getName(), new ProfileMenu(title, rows, slots, permission, isDefault));
        }
    }

    private ItemStack buildItemStack(FileCreator menus, String path, String key) {
        ItemStack item = null;
        if (menus.contains(path + ".material")) {
            try {
                Material material = Material.valueOf((String)menus.getString(path + ".material").toUpperCase());
                item = new ItemStack(material, menus.getInt(path + ".amount", 1));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("The '" + key + "' icon material does not exist.");
                return null;
            }
        } else if (menus.contains(path + ".item-adder")) {
            if (!this.plugin.existItemsAdder()) {
                this.plugin.getLogger().severe("ItemsAdder not installed... Skipping item '" + key + "'.");
                return null;
            }
            String itemsAdderId = menus.getString(path + ".item-adder");
            item = this.plugin.getItemsAdder().getCustomItemStack(itemsAdderId);
            if (item == null) {
                this.plugin.getLogger().severe("The '" + key + "' icon item from ItemsAdder does not exist.");
                return null;
            }
        } else if (menus.contains(path + ".nexo")) {
            if (!this.plugin.existNexo()) {
                this.plugin.getLogger().severe("Nexo is not installed... Skipping item '" + key + "'.");
                return null;
            }
            String nexoId = menus.getString(path + ".nexo");
            item = this.plugin.getNexo().getCustomItemStack(nexoId);
            if (item == null) {
                this.plugin.getLogger().severe("The '" + key + "' icon item from Nexo does not exist.");
                return null;
            }
        } else {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            String display = menus.getString(path + ".display", "");
            if (this.plugin.existItemsAdder()) {
                display = this.plugin.getItemsAdder().replaceFontImages(display);
            } else if (this.plugin.existNexo()) {
                display = this.plugin.getNexo().replaceFontImages(display);
            }
            if (!display.isEmpty()) {
                itemMeta.setDisplayName(display);
            }
            if (menus.contains(path + ".lore")) {
                List<String> lore = menus.getStringList(path + ".lore");
                if (this.plugin.existItemsAdder()) {
                    lore.replaceAll(line -> this.plugin.getItemsAdder().replaceFontImages((String)line));
                } else if (this.plugin.existNexo()) {
                    lore.replaceAll(line -> this.plugin.getNexo().replaceFontImages((String)line));
                }
                itemMeta.setLore(lore);
            }
            itemMeta.setUnbreakable(menus.getBoolean(path + ".unbreakable"));
            if (menus.getBoolean(path + ".hide-attributes")) {
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_POTION_EFFECTS});
            }
            if (menus.contains(path + ".custom-model-data")) {
                itemMeta.setCustomModelData(Integer.valueOf(menus.getInt(path + ".custom-model-data")));
            }
            if (menus.getBoolean(path + ".glow")) {
                item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(itemMeta);
        }
        return item;
    }

    public Menu<?> getProfileMenu() {
        return menuMap.get("profile");
    }

    public Menu<?> getProfileMenu(Player player) {
        for (Menu<?> menu : menuMap.values()) {
            if (menu.getPermission().isEmpty() || !player.hasPermission(menu.getPermission())) continue;
            return menu;
        }
        return this.getDefaultProfileMenu();
    }

    public Menu<?> getDefaultProfileMenu() {
        for (Menu<?> menu : menuMap.values()) {
            if (!menu.isDefault()) continue;
            return menu;
        }
        return menuMap.get("menu");
    }

    public int getRealSlot(int x, int y) {
        return (y - 1) * 9 + x;
    }

    public StatusMenu getChangeStatusMenu() {
        return this.statusMenu;
    }

    public Map<Inventory, IMenuHandler<?>> getActiveInventories() {
        return this.activeInventories;
    }
}

