/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.inventories;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.Menu;
import ru.sculmix.playerprofile.inventories.Slot;
import ru.sculmix.playerprofile.inventories.SlotType;

public class ProfileMenu
extends Menu<Inventory>
implements InventoryHolder {
    protected final int rows;

    public ProfileMenu(String title, int rows, Map<Integer, Slot> slots, String permission, boolean isDefault) {
        super(title, slots, permission, isDefault);
        this.rows = rows;
    }

    @Override
    public Inventory create(PlayerProfile plugin, PlayerData owner, Player viewer) {
        Player player = viewer == null ? owner.getOfflinePlayer().getPlayer() : viewer;
        PlayerData playerData = viewer == null ? owner : PlayerData.getPlayer(viewer);
        PlayerData playerData2 = playerData;
        if (!(viewer == null || viewer.hasPermission("playerprofile.bypass.private_profile") || viewer.getUniqueId().equals(owner.getUniqueId()) || owner.isPublicProfile())) {
            viewer.sendMessage(plugin.getConfig().getString("messages.prefix") + plugin.getConfig().getString("messages.player-profile-not-public"));
            return null;
        }
        Menu<Inventory> menu = this.getClone();
        playerData.setMenu(menu);
        menu.viewer = player;
        menu.owner = owner;
        menu.setUniqueId(owner.getUniqueId());
        menu.titlePlaceholders(player);
        menu.setInventory(Bukkit.createInventory((InventoryHolder)((InventoryHolder)menu), (int)(((ProfileMenu)menu).getRows() * 9), (String)menu.getTitle()));
        menu.setItems();
        player.openInventory(menu.getInventory());
        return menu.getInventory();
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
            if (!player.getUniqueId().equals(this.uniqueId) || event.isShiftClick()) {
                event.setCancelled(true);
            }
            return;
        }
        Slot slot = this.getSlot(event.getSlot());
        if (slot == null) {
            event.setCancelled(true);
            return;
        }
        if (slot.getSlotType() == SlotType.SAVED_ITEM && player.getUniqueId().equals(this.uniqueId)) {
            event.setCancelled(true);
            PlayerData playerData = PlayerData.getPlayer(player);
            ItemStack item = event.getCurrentItem();
            if (event.getCursor().getType().isAir()) {
                player.setItemOnCursor(item);
                if (item == null) {
                    return;
                }
                event.setCurrentItem(null);
                playerData.removeItemSaved(event.getSlot());
                return;
            }
            ItemStack cursor = event.getCursor().clone();
            player.setItemOnCursor(item);
            event.setCurrentItem(cursor);
            playerData.addItemSaved(event.getSlot(), cursor);
            return;
        }
        if (slot.getSlotType() == SlotType.DRAG_AND_DROP && player.getUniqueId().equals(this.uniqueId)) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType().isAir()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        slot.runActions(this.getOfflinePlayer(), player);
    }

    @Override
    public Menu<Inventory> getClone() {
        HashMap<Integer, Slot> slots = new HashMap<Integer, Slot>(this.getSlots());
        return new ProfileMenu(this.title, this.rows, slots, this.permission, this.isDefault);
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public Inventory getInventory() {
        return super.getInventory();
    }
}

