/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.inventories;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.ActionExecutorType;
import ru.sculmix.playerprofile.inventories.SlotType;
import ru.sculmix.playerprofile.providers.PlaceholderAPI;

public class Slot {
    private final String id;
    private int number;
    private final String permission;
    private final ItemStack itemStack;
    private final ItemStack online;
    private final ItemStack offline;
    private final ActionExecutorType actionExecutorType;
    private final List<String> actions;
    private final SlotType slotType;
    private final boolean texture;

    public Slot(String id, int number, ItemStack itemStack, List<String> actions, SlotType slotType, boolean texture, ActionExecutorType actionExecutorType, String permission) {
        this(id, number, itemStack, null, null, actions, slotType, texture, actionExecutorType, permission);
    }

    public Slot(String id, int number, ItemStack itemStack, ItemStack online, ItemStack offline, List<String> actions, SlotType slotType, boolean texture, ActionExecutorType actionExecutorType, String permission) {
        this.id = id;
        this.number = number;
        this.itemStack = itemStack;
        this.online = online;
        this.offline = offline;
        this.actions = actions;
        this.slotType = slotType;
        this.texture = texture;
        this.actionExecutorType = actionExecutorType;
        this.permission = permission;
    }

    public Slot getClone() {
        return new Slot(this.id, this.number, this.itemStack != null ? this.itemStack.clone() : null, this.online != null ? this.online.clone() : null, this.offline != null ? this.offline.clone() : null, this.actions, this.slotType, this.texture, this.actionExecutorType, this.permission);
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void runActions(OfflinePlayer owner, Player player) {
        if (this.actionExecutorType == ActionExecutorType.OWNER ? !player.getUniqueId().equals(owner.getUniqueId()) : this.actionExecutorType == ActionExecutorType.VIEWER && player.getUniqueId().equals(owner.getUniqueId())) {
            return;
        }
        for (String action : this.getActions()) {
            this.runAction(action, owner, player);
        }
    }

    public void runAction(String action, OfflinePlayer owner, Player player) {
        PlayerProfile plugin = PlayerProfile.getInstance();
        if (action.startsWith("owner_message: ")) {
            action = action.replace("owner_message: ", "").replace("%viewer%", player.getName()).replace("%owner%", owner.getName());
            if (!owner.isOnline()) {
                return;
            }
            if (plugin.existPlaceholderAPI()) {
                action = plugin.getPlaceholderAPI().setPlaceholders(owner, action);
            }
            Player p = owner.getPlayer();
            p.sendMessage(action);
            return;
        }
        if (action.startsWith("viewer_message: ")) {
            action = action.replace("viewer_message: ", "").replace("%viewer%", player.getName()).replace("%owner%", owner.getName());
            if (plugin.existPlaceholderAPI()) {
                action = plugin.getPlaceholderAPI().setPlaceholders(owner, action);
            }
            player.sendMessage(action);
            return;
        }
        if (action.startsWith("player: ")) {
            action = action.replace("player: ", "").replace("%viewer%", player.getName()).replace("%owner%", owner.getName());
            if (plugin.existPlaceholderAPI()) {
                action = plugin.getPlaceholderAPI().setPlaceholders(owner, action);
            }
            player.performCommand(action);
            return;
        }
        if (action.startsWith("console: ")) {
            action = action.replace("console: ", "").replace("%viewer%", player.getName()).replace("%owner%", owner.getName());
            if (plugin.existPlaceholderAPI()) {
                action = plugin.getPlaceholderAPI().setPlaceholders(owner, action);
            }
            plugin.getServer().dispatchCommand((CommandSender)plugin.getServer().getConsoleSender(), action);
            return;
        }
        if (action.equalsIgnoreCase("close_inventory")) {
            player.closeInventory();
            return;
        }
        action = action.replace("%viewer%", player.getName()).replace("%owner%", owner.getName());
        if (plugin.existPlaceholderAPI()) {
            action = plugin.getPlaceholderAPI().setPlaceholders(owner, action);
        }
        player.performCommand(action);
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemStack getItemPlaceholders(PlayerData playerData) {
        PlayerProfile plugin = PlayerProfile.getInstance();
        if (this.itemStack == null) {
            return null;
        }
        if (!plugin.existPlaceholderAPI()) {
            return this.itemStack;
        }
        ItemStack itemCopy = this.itemStack.clone();
        PlaceholderAPI placeholderAPI = plugin.getPlaceholderAPI();
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        ItemMeta metaCopy = itemCopy.getItemMeta();
        if (metaCopy == null) {
            return itemCopy;
        }
        if (metaCopy.hasDisplayName()) {
            metaCopy.setDisplayName(placeholderAPI.setPlaceholders(playerData.getOfflinePlayer(), itemMeta.getDisplayName()));
        }
        if (metaCopy.hasLore()) {
            metaCopy.setLore(placeholderAPI.setPlaceholders(playerData.getOfflinePlayer(), itemMeta.getLore()));
        }
        if (metaCopy instanceof SkullMeta && !this.texture) {
            SkullMeta skullMeta = (SkullMeta)metaCopy;
            skullMeta.setOwningPlayer(playerData.getOfflinePlayer());
            itemCopy.setItemMeta((ItemMeta)skullMeta);
        } else {
            itemCopy.setItemMeta(metaCopy);
        }
        return itemCopy;
    }

    public ItemStack getItemPlaceholders(PlayerData offlinePlayer, Player player) {
        PlayerProfile plugin = PlayerProfile.getInstance();
        ItemStack itemStack = this.getStatusPlayer(offlinePlayer);
        if (itemStack == null) {
            return null;
        }
        ItemStack itemCopy = itemStack.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta metaCopy = itemCopy.getItemMeta();
        if (plugin.existPlaceholderAPI()) {
            PlaceholderAPI placeholderAPI = plugin.getPlaceholderAPI();
            if (metaCopy == null) {
                return itemCopy;
            }
            if (metaCopy.hasDisplayName()) {
                metaCopy.setDisplayName(placeholderAPI.setPlaceholders(offlinePlayer.getOfflinePlayer(), itemMeta.getDisplayName()).replace("%owner%", offlinePlayer.getPlayerName()).replace("%viewer%", player.getName()));
            }
            if (metaCopy.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : itemMeta.getLore()) {
                    lore.add(line.replace("%owner%", offlinePlayer.getPlayerName()).replace("%viewer%", player.getName()));
                }
                metaCopy.setLore(placeholderAPI.setPlaceholders(offlinePlayer.getOfflinePlayer(), lore));
            }
        }
        if (metaCopy instanceof SkullMeta && !this.texture) {
            SkullMeta skullMeta = (SkullMeta)metaCopy;
            skullMeta.setOwningPlayer(offlinePlayer.getOfflinePlayer());
            itemCopy.setItemMeta((ItemMeta)skullMeta);
        } else {
            itemCopy.setItemMeta(metaCopy);
        }
        return itemCopy;
    }

    public ItemStack getStatusPlayer(PlayerData player) {
        if (!this.isStatus()) {
            return this.itemStack;
        }
        if (player.isOnline()) {
            return this.online != null ? this.online : this.itemStack;
        }
        return this.offline != null ? this.offline : this.itemStack;
    }

    public String getId() {
        return this.id;
    }

    public SlotType getSlotType() {
        return this.slotType;
    }

    public boolean isDefault() {
        return this.slotType == SlotType.DEFAULT;
    }

    public boolean isStatus() {
        return this.slotType == SlotType.STATUS;
    }

    public ItemStack getOffline() {
        return this.offline;
    }

    public ItemStack getOnline() {
        return this.online;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission(Player player) {
        if (this.permission.isEmpty()) {
            return true;
        }
        return player.hasPermission(this.permission);
    }
}

