/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.inventories.handlers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import ru.sculmix.playerprofile.CustomAnvilContainer;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.Menu;
import ru.sculmix.playerprofile.inventories.Slot;
import ru.sculmix.playerprofile.inventories.SlotType;

public class StatusMenu
extends Menu<AnvilInventory> {
    private CustomAnvilContainer customAnvilContainer;
    private PlayerData playerData;

    public StatusMenu(String title, Map<Integer, Slot> slots) {
        super(title, slots, "", false);
    }

    @Override
    public AnvilInventory create(PlayerProfile plugin, PlayerData owner, Player viewer) {
        StatusMenu menu = this.getClone();
        menu.titlePlaceholders(owner);
        menu.playerData = owner;
        menu.customAnvilContainer = plugin.getNmsHandler().getCustomAnvil(owner.getOfflinePlayer().getPlayer(), menu.getTitle());
        menu.setInventory((AnvilInventory)menu.customAnvilContainer.getBukkitInventory());
        owner.getOfflinePlayer().getPlayer().openInventory((Inventory)menu.getInventory());
        menu.setItems(owner);
        owner.setStatusMenu(menu);
        return menu.getInventory();
    }

    public void titlePlaceholders(PlayerData owner) {
        PlayerProfile playerProfile = PlayerProfile.getInstance();
        if (!playerProfile.existPlaceholderAPI()) {
            return;
        }
        this.title = playerProfile.getPlaceholderAPI().setPlaceholders(owner.getOfflinePlayer(), this.title.replace("%player%", owner.getPlayerName()));
    }

    public void setItems(PlayerData owner) {
        for (Slot slot : this.getSlots().values()) {
            this.customAnvilContainer.setItemAuto(slot.getNumber(), slot.getItemPlaceholders(owner));
        }
        this.customAnvilContainer.updateTitle();
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        Slot slot = this.getSlot(event.getSlot());
        if (slot == null) {
            return;
        }
        if (slot.getSlotType() == SlotType.CHANGE_STATUS_ACCEPT) {
            if (this.customAnvilContainer.getTextWriting() == null || this.customAnvilContainer.getTextWriting().isEmpty()) {
                return;
            }
            this.playerData.setStatus(this.customAnvilContainer.getTextWriting());
            this.playerData.returnToMenuSuccess();
            return;
        }
        this.playerData.returnToMenuCancel();
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        PlayerProfile plugin = PlayerProfile.getInstance();
        plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> this.playerData.returnToMenuCancel());
    }

    @Override
    public void setInventory(AnvilInventory inventory) {
        inventory.setRepairCost(0);
        inventory.setMaximumRepairCost(0);
        inventory.setRepairCostAmount(0);
        super.setInventory(inventory);
    }

    public StatusMenu getClone() {
        HashMap<Integer, Slot> slots = new HashMap<Integer, Slot>(this.getSlots());
        return new StatusMenu(this.title, slots);
    }

    @Override
    public AnvilInventory getInventory() {
        return (AnvilInventory)super.getInventory();
    }

    @Override
    public CustomAnvilContainer getCustomAnvilContainer() {
        return this.customAnvilContainer;
    }
}

