/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.ProfileMenu;
import ru.sculmix.playerprofile.inventories.handlers.StatusMenu;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerData playerData = PlayerData.getPlayer(player);
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (playerData.getStatusMenu() != null && playerData.getStatusMenu().getInventory().equals((Object)event.getInventory())) {
            event.setCancelled(true);
            if (event.getClickedInventory() == null) {
                return;
            }
            if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
                return;
            }
            StatusMenu statusMenu = playerData.getStatusMenu();
            statusMenu.onClick(event);
            return;
        }
        if (!(inventoryHolder instanceof ProfileMenu)) {
            return;
        }
        ProfileMenu profileMenu = (ProfileMenu)inventoryHolder;
        profileMenu.onClick(event);
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerData playerData = PlayerData.getPlayer(player);
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (playerData.getStatusMenu() != null && playerData.getStatusMenu().getInventory().equals((Object)event.getInventory())) {
            event.setCancelled(true);
            return;
        }
        if (!(inventoryHolder instanceof ProfileMenu)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        PlayerData playerData = PlayerData.getPlayer(player);
        if (playerData.getStatusMenu() == null) {
            return;
        }
        if (!playerData.getStatusMenu().getInventory().equals((Object)event.getInventory())) {
            return;
        }
        StatusMenu statusMenu = playerData.getStatusMenu();
        statusMenu.onClose(event);
    }
}

