/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;

public class PlayerInteractListener
implements Listener {
    private final PlayerProfile plugin;

    public PlayerInteractListener(PlayerProfile plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent event) {
        if (!this.plugin.isShiftOpenProfile()) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getRightClicked();
        if (target.hasMetadata("NPC")) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        PlayerData owner = PlayerData.getPlayer(target);
        this.plugin.getMenuLoader().getProfileMenu(target).create(this.plugin, owner, player);
    }
}

