/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.nms.v1_21_R3.entity;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.sculmix.playerprofile.CustomAnvilContainer;

public class ImplCustomAnvilContainer
extends AnvilMenu
implements CustomAnvilContainer {
    private final ServerPlayer entityPlayer;
    private final String title;
    private net.minecraft.world.item.ItemStack itemResult;
    private boolean useResultSlot;
    public String itemName;

    public ImplCustomAnvilContainer(org.bukkit.entity.Player player, String title) {
        this(((CraftPlayer)player).getHandle(), (Level)((CraftWorld)player.getWorld()).getHandle(), ((CraftPlayer)player).getHandle().nextContainerCounter(), ((CraftPlayer)player).getHandle().getInventory(), title);
    }

    protected ImplCustomAnvilContainer(ServerPlayer entityPlayer, Level world, int i, net.minecraft.world.entity.player.Inventory playerinventory, String title) {
        super(i, playerinventory, ContainerLevelAccess.create((Level)world, (BlockPos)new BlockPos(0, 0, 0)));
        this.checkReachable = false;
        this.entityPlayer = entityPlayer;
        this.title = title;
        this.useResultSlot = false;
        try {
            Field fResult = ItemCombinerMenu.class.getDeclaredField("resultSlots");
            Field fRenameText = AnvilMenu.class.getDeclaredField("itemName");
            fResult.setAccessible(true);
            fRenameText.setAccessible(true);
            fResult.set(this, new ResultContainer());
            this.itemName = "";
            fRenameText.set(this, this.itemName);
        }
        catch (IllegalAccessException | NoSuchFieldException var8) {
            var8.printStackTrace();
        }
    }

    @Override
    public void updateTitle() {
        this.entityPlayer.connection.send((Packet)new ClientboundOpenScreenPacket(this.entityPlayer.containerMenu.containerId, MenuType.ANVIL, Component.nullToEmpty((String)this.title)));
        this.entityPlayer.inventoryMenu.sendAllDataToRemote();
        if (this.itemResult != null) {
            this.entityPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.entityPlayer.containerMenu.containerId, this.entityPlayer.containerMenu.getStateId(), 2, this.itemResult));
        }
        this.entityPlayer.connection.send((Packet)new ClientboundContainerSetDataPacket(this.entityPlayer.containerMenu.containerId, 0, 0));
    }

    public void removed(Player entityhuman) {
    }

    protected void clearContainer(Player entityhuman, Container iinventory) {
    }

    public boolean setItemName(String s) {
        this.itemName = s;
        return super.setItemName(s);
    }

    @Override
    public void setTextWriting(String text) {
        this.setItemName(text);
        if (this.useResultSlot) {
            this.entityPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.entityPlayer.inventoryMenu.containerId, this.entityPlayer.inventoryMenu.getStateId(), 2, this.itemResult));
            this.entityPlayer.connection.send((Packet)new ClientboundContainerSetDataPacket(this.entityPlayer.inventoryMenu.containerId, 0, 0));
        }
    }

    @Override
    public String getTextWriting() {
        return this.itemName;
    }

    @Override
    public void setItemAuto(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                this.setItemLeft(itemStack);
                break;
            }
            case 1: {
                this.setItemRight(itemStack);
                break;
            }
            case 2: {
                this.setItemResult(itemStack);
            }
        }
    }

    @Override
    public void setItemLeft(ItemStack itemStack) {
        this.getSlot(0).setByPlayer(CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void setItemRight(ItemStack itemStack) {
        this.getSlot(1).setByPlayer(CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void setItemResult(ItemStack itemStack) {
        this.itemResult = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (this.itemResult != null) {
            this.itemResult.setPopTime(0);
        }
        this.getSlot(2).setByPlayer(this.itemResult);
        this.useResultSlot = true;
    }

    @Override
    public Inventory getBukkitInventory() {
        return this.getBukkitView().getTopInventory();
    }
}

