/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.nms.v1_21_R4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import ru.sculmix.playerprofile.CustomAnvilContainer;
import ru.sculmix.playerprofile.INMSHandler;
import ru.sculmix.playerprofile.nms.v1_21_R4.entity.ImplCustomAnvilContainer;
import ru.sculmix.playerprofile.nms.v1_21_R4.network.PChannelHandler;

public class NMSHandler_v1_21_R4
implements INMSHandler {
    @Override
    public void injectPlayer(Player player) {
        ServerPlayer ply = ((CraftPlayer)player).getHandle();
        PChannelHandler pch = new PChannelHandler(ply);
        ChannelPipeline pipeline = this.getPrivateChannelPipeline(ply.connection);
        if (pipeline != null) {
            for (String name : pipeline.toMap().keySet()) {
                if (!(pipeline.get(name) instanceof Connection)) continue;
                pipeline.addBefore(name, "player_profile_packet_handler", (ChannelHandler)pch);
                break;
            }
        }
    }

    @Override
    public void removePlayer(Player player) {
        Channel channel = this.getPrivateChannel(((CraftPlayer)player).getHandle().connection);
        if (channel != null) {
            channel.eventLoop().submit(() -> {
                channel.pipeline().remove("player_profile_packet_handler");
                return null;
            });
        }
    }

    @Override
    public CustomAnvilContainer getCustomAnvil(Player player, String title) {
        return new ImplCustomAnvilContainer(player, title);
    }

    private ChannelPipeline getPrivateChannelPipeline(ServerGamePacketListenerImpl playerConnection) {
        try {
            Field privateNetworkManager = ServerCommonPacketListenerImpl.class.getDeclaredField("connection");
            privateNetworkManager.setAccessible(true);
            Connection networkManager = (Connection)privateNetworkManager.get(playerConnection);
            return networkManager.channel.pipeline();
        }
        catch (IllegalAccessException | NoSuchFieldException var4) {
            Bukkit.getLogger().severe("Error: Channel pipeline not found");
            return null;
        }
    }

    private Channel getPrivateChannel(ServerGamePacketListenerImpl playerConnection) {
        try {
            Field privateNetworkManager = ServerCommonPacketListenerImpl.class.getDeclaredField("connection");
            privateNetworkManager.setAccessible(true);
            Connection networkManager = (Connection)privateNetworkManager.get(playerConnection);
            return networkManager.channel;
        }
        catch (IllegalAccessException | NoSuchFieldException var4) {
            Bukkit.getLogger().severe("Error: Channel not found");
            return null;
        }
    }
}

