/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.providers;

import com.nexomc.nexo.NexoPlugin;
import com.nexomc.nexo.api.NexoItems;
import com.nexomc.nexo.fonts.FontManager;
import com.nexomc.nexo.glyphs.Glyph;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class Nexo {
    private final Pattern pattern = Pattern.compile(":\\w+:");

    public ItemStack getCustomItemStack(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (NexoItems.itemFromId((String)id) != null) {
            return NexoItems.itemFromId((String)id).build();
        }
        return null;
    }

    public String replaceFontImages(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        NexoPlugin nexoPlugin = NexoPlugin.instance();
        if (nexoPlugin == null || nexoPlugin.fontManager() == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        FontManager fontManager = nexoPlugin.fontManager();
        Matcher matcher = this.pattern.matcher(text);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String glyphName = placeholder.replace(":", "");
            Glyph glyph = fontManager.glyphFromID(glyphName);
            if (glyph != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(glyph.getFormattedUnicodes()));
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(placeholder));
        }
        matcher.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString());
    }
}

