/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.providers;

import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.Menu;

public class PlaceholderAPI
extends PlaceholderExpansion {
    private final PlayerProfile plugin = PlayerProfile.getInstance();

    public PlaceholderAPI() {
        this.register();
    }

    public List<String> setPlaceholders(OfflinePlayer offlinePlayer, List<String> message) {
        if (message.isEmpty() || message == null) {
            return new ArrayList<String>();
        }
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, message);
    }

    public String setPlaceholders(OfflinePlayer offlinePlayer, String message) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)message);
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "Sculmix";
    }

    public String getIdentifier() {
        return "playerprofile";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        PlayerData data = PlayerData.getOfflinePlayer(player.getName());
        if (data == null) {
            return "";
        }
        if (identifier.equals("viewer")) {
            return player.getName();
        }
        if (identifier.equals("status")) {
            return data.getStatus();
        }
        if (identifier.equals("is_public")) {
            return String.valueOf(data.isPublicProfile());
        }
        Menu menu = data.getMenu();
        if (menu == null) {
            return "";
        }
        if (identifier.equals("owner")) {
            return menu.getOfflinePlayer().getName();
        }
        return "";
    }
}

