/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import ru.sculmix.playerprofile.PlayerProfile;

public class Utils {
    private static final Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");

    public static String getVersion() {
        return Bukkit.getServer().getBukkitVersion().split("-")[0];
    }

    public static String ChatColor(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String version = Utils.getVersion();
        if (version.contains("1.16") || version.contains("1.17") || version.contains("1.18") || version.contains("1.19") || version.contains("1.20") || version.contains("1.21")) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                message = message.replace(color, String.valueOf(ChatColor.of((String)color)));
                matcher = pattern.matcher(message);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String itemStackToBase64(ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)item.serialize());
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack itemStackFromBase64(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Map serialized = (Map)dataInput.readObject();
            ItemStack item = ItemStack.deserialize((Map)serialized);
            dataInput.close();
            return item;
        }
        catch (IOException | ClassNotFoundException | IllegalArgumentException e) {
            if (PlayerProfile.getInstance() != null) {
                PlayerProfile.getInstance().getLogger().severe("Unable to decode class type." + String.valueOf(e));
                PlayerProfile.getInstance().getLogger().info("Data: " + data);
            }
            return null;
        }
    }

    public static String serializeInventoryToBase64(Map<Integer, ItemStack> inventory) {
        StringBuilder serialized = new StringBuilder();
        for (Map.Entry<Integer, ItemStack> entry : inventory.entrySet()) {
            serialized.append(entry.getKey()).append(":").append(Utils.itemStackToBase64(entry.getValue())).append(";");
        }
        return Base64Coder.encodeLines((byte[])serialized.toString().getBytes());
    }

    public static Map<Integer, ItemStack> deserializeInventoryFromBase64(String base64) {
        String[] entries;
        HashMap<Integer, ItemStack> inventory = new HashMap<Integer, ItemStack>();
        if (base64 == null || base64.isEmpty()) {
            return inventory;
        }
        String decoded = new String(Base64Coder.decodeLines((String)base64));
        for (String entry : entries = decoded.split(";")) {
            String[] parts;
            if (entry.isEmpty() || (parts = entry.split(":", 2)).length < 2) continue;
            int slot = Integer.parseInt(parts[0]);
            ItemStack itemStack = Utils.itemStackFromBase64(parts[1]);
            inventory.put(slot, itemStack);
        }
        return inventory;
    }

    public static ItemStack getCustomHead(ItemStack itemStack, String texture) {
        if (itemStack == null) {
            return null;
        }
        if (texture.isEmpty()) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return itemStack;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (Utils.lastVersion()) {
            org.bukkit.profile.PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            try {
                URL url = texture.startsWith("http") ? new URL(texture) : Utils.getUrlFromBase64(texture);
                textures.setSkin(url);
                profile.setTextures(textures);
                skullMeta.setOwnerProfile(profile);
            }
            catch (MalformedURLException e) {
                Bukkit.getLogger().warning("The url of the texture is invalid!");
            }
        } else {
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            try {
                Field profileField = skullMeta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(skullMeta, gameProfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        String urlString = decoded.substring("{\"textures\":{\"SKIN\":{\"url\":\"".length(), decoded.length() - "\"}}}".length());
        return new URL(urlString);
    }

    public static boolean lastVersion() {
        String version = Utils.getVersion();
        return version.contains("1.18.2") || version.contains("1.19") || version.contains("1.20") || version.contains("1.21");
    }
}

