package com.provismet.datagen.proviorigins;

import com.provismet.proviorigins.utility.tags.POBiomeTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.concurrent.CompletableFuture;

public class BiomeTagGenerator extends FabricTagProvider<class_1959> {
    public BiomeTagGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, class_7924.field_41236, registriesFuture);
    }

    @Override
    protected void method_10514 (class_7225.class_7874 arg) {
        method_10512(POBiomeTags.HOT_UNDERGROUND)
            .addOptionalTag(ConventionalBiomeTags.IN_NETHER)
            .method_35922(class_2960.method_43902("terralith", "cave/thermal_caves"));

        method_10512(POBiomeTags.HAS_SALTWATER)
            .addOptionalTag(POBiomeTags.IRRELEVANT_SALINITY)
            .method_46835(class_1972.field_9419)
            .addOptionalTag(ConventionalBiomeTags.BEACH)
            .addOptionalTag(ConventionalBiomeTags.OCEAN)
            .method_35922(class_2960.method_43902("terralith", "alpha_islands"))
            .method_35922(class_2960.method_43902("terralith", "alpha_islands_winter"))
            .method_35922(class_2960.method_43902("terralith", "mirage_isles"));

        method_10512(POBiomeTags.IRRELEVANT_SALINITY)
            .addOptionalTag(ConventionalBiomeTags.IN_NETHER)
            .addOptionalTag(ConventionalBiomeTags.IN_THE_END)
            .method_46835(class_1972.field_9473)
            .method_46835(class_1972.field_9462)
            .method_35923(class_2960.method_43902("terralith", "skylands"));

        method_10512(POBiomeTags.SOUL_COLLECTOR)
            .method_46835(class_1972.field_22076)
            .method_35922(class_2960.method_43902("byg", "warped_desert"))
            .method_35922(class_2960.method_43902("betternether", "wart_forest"))
            .method_35922(class_2960.method_43902("betternether", "wart_forest_edge"))
            .method_35922(class_2960.method_43902("betternether", "soul_plain"))
            .method_35922(class_2960.method_43902("betternether", "nether_grasslands"))
            .method_35922(class_2960.method_43902("betternether", "poor_nether_grasslands"));

        method_10512(POBiomeTags.ALWAYS_GROW)
            .method_46835(class_1972.field_29218)
            .method_35922(class_2960.method_43902("terralith", "cave/underground_jungle"));

        method_10512(POBiomeTags.NATURAL)
            .addOptionalTag(ConventionalBiomeTags.FOREST)
            .addOptionalTag(ConventionalBiomeTags.JUNGLE)
            .addOptionalTag(ConventionalBiomeTags.FLORAL)
            .addOptionalTag(ConventionalBiomeTags.VEGETATION_DENSE)
            .addOptionalTag(POBiomeTags.ALWAYS_GROW);
    }
}
