package com.provismet.datagen.proviorigins;

import com.provismet.proviorigins.content.registries.POBlocks;
import com.provismet.proviorigins.utility.tags.POBlockTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class BlockTagGenerator extends FabricTagProvider.BlockTagProvider {
    public BlockTagGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void method_10514 (class_7225.class_7874 arg) {
        method_10512(class_3481.field_15480)
            .add(POBlocks.LILY_OF_THE_VOID);

        method_10512(POBlockTags.VOID_PLANTABLE)
            .addOptionalTag(POBlockTags.VOID_TOUCHING)
            .addOptionalTag(POBlockTags.WEAKLY_VOID_TOUCHING)
            .method_35922(class_2960.method_43902("betterend", "shadow_grass"))
            .method_35922(class_2960.method_43902("betterend", "chorus_nylium"))
            .method_35922(class_2960.method_43902("betterend", "pink_moss"));

        method_10512(POBlockTags.VOID_TOUCHING)
            .add(class_2246.field_9987)
            .add(class_2246.field_23152)
            .addOptionalTag(class_3481.field_21780);

        method_10512(POBlockTags.WEAKLY_VOID_TOUCHING)
            .add(class_2246.field_22423)
            .method_35922(class_2960.method_43902("betternether", "weeping_obsidian"))
            .method_35922(class_2960.method_43902("betternether", "blue_crying_obsidian"))
            .method_35922(class_2960.method_43902("betternether", "blue_weeping_obsidian"));

        method_10512(POBlockTags.SOUL_FIRES)
            .add(class_2246.field_22092)
            .add(class_2246.field_22093)
            .add(class_2246.field_22110)
            .add(class_2246.field_22089);

        method_10512(POBlockTags.SOUL_FIRES_WITH_FIRE_BLOCKSTATE)
            .method_35922(class_2960.method_43902("betternether", "cincinnasite_fire_bowl_soul"))
            .method_35922(class_2960.method_43902("betternether", "bricks_fire_bowl_soul"))
            .method_35922(class_2960.method_43902("betternether", "netherite_fire_bowl_soul"));

        method_10512(POBlockTags.SOUL_FIRES_WITH_LIT_BLOCKSTATE)
            .add(class_2246.field_23860);

        method_10512(POBlockTags.SCULK)
            .add(class_2246.field_37568)
            .add(class_2246.field_28108)
            .add(class_2246.field_37570)
            .add(class_2246.field_37569)
            .add(class_2246.field_37571);

        method_10512(POBlockTags.LARGE_FIRES)
            .add(class_2246.field_16541)
            .add(class_2246.field_22110)
            .add(class_2246.field_10036)
            .add(class_2246.field_22089);

        method_10512(POBlockTags.LARGE_FIRES_WITH_FIRE_BLOCKSTATE)
            .addOptionalTag(POBlockTags.SOUL_FIRES_WITH_FIRE_BLOCKSTATE)
            .method_35922(class_2960.method_43902("betternether", "cincinnasite_fire_bowl"))
            .method_35922(class_2960.method_43902("betternether", "bricks_fire_bowl"))
            .method_35922(class_2960.method_43902("betternether", "netherite_fire_bowl"));

        method_10512(POBlockTags.LARGE_FIRES_WITH_LIT_BLOCKSTATE)
            .addOptionalTag(POBlockTags.SOUL_FIRES_WITH_LIT_BLOCKSTATE)
            .add(class_2246.field_17350);

        method_10512(POBlockTags.TORCHES)
            .add(class_2246.field_10336)
            .add(class_2246.field_10099)
            .add(class_2246.field_22092)
            .add(class_2246.field_22093)
            .addOptionalTag(class_3481.field_26983)
            .method_35922(class_2960.method_43902("betternether", "willow_torch"));

        method_10512(POBlockTags.FOLIAGE)
            .addOptionalTag(class_3481.field_20339)
            .addOptionalTag(class_3481.field_15462); // Missing Apoli
    }
}
