package com.provismet.datagen.proviorigins;

import com.provismet.proviorigins.content.registries.POItems;
import com.provismet.proviorigins.utility.OriginList;
import com.provismet.proviorigins.utility.tags.POItemTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.concurrent.CompletableFuture;

public class ItemTagGenerator extends FabricTagProvider.ItemTagProvider {
    public ItemTagGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture);
    }

    @Override
    protected void method_10514 (class_7225.class_7874 arg) {
        final class_6862<class_1792> hidden = class_6862.method_40092(class_7924.field_41197, class_2960.method_43902("c", "hidden_from_recipe_viewers"));
        method_10512(hidden)
            .method_46835(OriginList.LILY_OF_THE_VOID.getIconKey())
            .method_46835(OriginList.KRAKEN_OF_DECAY.getIconKey())
            .method_46835(OriginList.DRAKLING.getIconKey())
            .method_46835(OriginList.DRAKE.getIconKey())
            .method_46835(OriginList.SPLINTER.getIconKey())
            .method_46835(OriginList.FAERIE_MOTH.getIconKey())
            .method_46835(OriginList.ALRAUNE.getIconKey())
            .method_46835(OriginList.HOMUNCULUS.getIconKey())
            .method_46835(OriginList.CRYSTALLISER.getIconKey());

        method_10512(class_3489.field_15543)
            .add(POItems.LILY_OF_THE_VOID);

        method_10512(class_3489.field_23064)
            .add(POItems.SOUL_LAMP);

        method_10512(POItemTags.HYDRATE_ON_USE)
            .add(class_1802.field_8574);

        method_10512(POItemTags.GRANTS_ARMOUR)
            .addOptionalTag(class_3489.field_23212);

        method_10512(POItemTags.GRANTS_BLINDNESS)
            .add(class_1802.field_17501)
            .method_35922(class_2960.method_43902("betterend", "murkweed"));

        method_10512(POItemTags.GRANTS_CORRUPTION)
            .add(class_1802.field_17514)
            .add(POItems.LILY_OF_THE_VOID)
            .method_35922(class_2960.method_43902("betterend", "end_lily_seed"))
            .method_35922(class_2960.method_43902("betterend", "end_lotus_seed"));

        method_10512(POItemTags.GRANTS_FIRE_RESISTANCE)
            .add(class_1802.field_17500)
            .method_35922(class_2960.method_43902("betternether", "magma_flower"));

        method_10512(POItemTags.GRANTS_GLOW)
            .add(class_1802.field_28659)
            .method_35922(class_2960.method_43902("betterend", "glowing_pillar_leaves"))
            .method_35922(class_2960.method_43902("betterend", "lumecorn_rod"))
            .method_35922(class_2960.method_43902("betterend", "blue_vine_fur"));

        method_10512(POItemTags.GRANTS_JUMP_BOOST)
            .add(class_1802.field_17513);

        method_10512(POItemTags.GRANTS_NIGHT_VISION)
            .add(class_1802.field_8880)
            .add(class_1802.field_42695);

        method_10512(POItemTags.GRANTS_REGENERATION)
            .add(class_1802.field_17512);

        method_10512(POItemTags.GRANTS_SATURATION)
            .add(class_1802.field_17499)
            .add(class_1802.field_8491);

        method_10512(POItemTags.GRANTS_SPEED)
            .add(class_1802.field_17531);

        method_10512(POItemTags.GRANTS_TELEPORT)
            .add(class_1802.field_8233);

        method_10512(POItemTags.GRANTS_THORNS)
            .add(class_1802.field_17520)
            .add(class_1802.field_17527)
            .add(class_1802.field_16998)
            .method_35922(class_2960.method_43902("betternether", "nether_cactus"))
            .method_35922(class_2960.method_43902("betternether", "barrel_cactus"))
            .method_35922(class_2960.method_43902("betterend", "needlegrass"))
            .method_35922(class_2960.method_43902("betterend", "neon_cactus"));

        method_10512(POItemTags.GRANTS_WATER_BREATHING)
            .add(class_1802.field_17532)
            .method_35922(class_2960.method_43902("betterend", "charnia_red"))
            .method_35922(class_2960.method_43902("betterend", "charnia_orange"))
            .method_35922(class_2960.method_43902("betterend", "charnia_purple"))
            .method_35922(class_2960.method_43902("betterend", "charnia_light_blue"))
            .method_35922(class_2960.method_43902("betterend", "charnia_cyan"))
            .method_35922(class_2960.method_43902("betterend", "charnia_green"));

        method_10512(POItemTags.GRANTS_WEAKNESS)
            .add(class_1802.field_17502)
            .add(class_1802.field_17509)
            .add(class_1802.field_17510)
            .add(class_1802.field_17511);

        method_10512(POItemTags.GRANTS_WITHER)
            .add(class_1802.field_17515);

        method_10512(POItemTags.SOUL_CARRY)
            .add(class_1802.field_22016)
            .add(POItems.SOUL_LAMP);

        method_10512(POItemTags.MAX_SOUL_CONSUME)
            .add(class_1802.field_8288)
            .add(class_1802.field_8791)
            .add(class_1802.field_8137);

        method_10512(POItemTags.MEDIUM_SOUL_CONSUME)
            .add(class_1802.field_22016)
            .add(class_1802.field_37525);

        method_10512(POItemTags.WEAK_SOUL_CONSUME)
            .add(class_1802.field_22001);

        method_10512(POItemTags.LIGHT_SOURCES)
            .addOptionalTag(POItemTags.SOUL_CARRY)
            .add(class_1802.field_8810)
            .add(class_1802.field_22001)
            .add(class_1802.field_16539)
            .add(POItems.SOLID_LANTERN);

        method_10512(POItemTags.SUMMON_AOE)
            .add(class_1802.field_42695)
            .add(class_1802.field_17502)
            .add(class_1802.field_17509)
            .add(class_1802.field_17510)
            .add(class_1802.field_17511)
            .add(class_1802.field_17499)
            .add(class_1802.field_17512)
            .method_35922(class_2960.method_43902("betterend", "flammalix"))
            .method_35922(class_2960.method_43902("betterend", "aeridium"));

        method_10512(POItemTags.SUMMON_PROJECTILE)
            .add(class_1802.field_17515)
            .addOptionalTag(POItemTags.GRANTS_CORRUPTION);

        method_10512(POItemTags.SUMMON_PULL)
            .add(class_1802.field_43192)
            .add(class_1802.field_8880)
            .add(class_1802.field_17501)
            .add(class_1802.field_17525)
            .add(class_1802.field_17529)
            .method_35922(class_2960.method_43902("betterend", "tenanea_flowers"))
            .method_35922(class_2960.method_43902("betterend", "twisted_umbrella_moss"));

        method_10512(POItemTags.SUMMON_PUSH)
            .add(class_1802.field_17527)
            .add(class_1802.field_8491)
            .add(class_1802.field_17500)
            .add(class_1802.field_17513)
            .add(class_1802.field_17526)
            .method_35922(class_2960.method_43902("betterend", "blooming_cooksonia"))
            .method_35922(class_2960.method_43902("betterend", "umbrella_moss"));

        method_10512(POItemTags.FERTILISER)
            .add(class_1802.field_8613);
    }
}
