package com.provismet.datagen.proviorigins;

import com.provismet.proviorigins.content.world.features.FeaturesConfigured;
import com.provismet.proviorigins.content.world.features.FeaturesPlaced;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class ProviOriginsDataGenerator implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator (FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(WorldGenerator::new);
        pack.addProvider(RecipeGenerator::new);
        pack.addProvider(LanguageGenerator::new);
        pack.addProvider(LanguageGeneratorUK::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(EntityTypeTagGenerator::new);
        pack.addProvider(BlockTagGenerator::new);
        pack.addProvider(BiomeTagGenerator::new);
        pack.addProvider(LootTableGenerator::new);
        pack.addProvider(ModelGenerator::new);
    }
    
    @Override
    public void buildRegistry (class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, FeaturesConfigured::buildFeatures);
        registryBuilder.method_46777(class_7924.field_41245, FeaturesPlaced::buildPlacedFeatures);
    }
}
