package com.provismet.proviorigins.actions;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3545;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

public class ActOnFarthestEntityAction {
    public static void action (SerializableData.Instance data, class_1297 entity) {
        final double distance = data.getDouble(Powers.DISTANCE);
        final Consumer<class_3545<class_1297, class_1297>> bientityAction = data.get(Powers.BIENTITY_ACTION);
        final Predicate<class_3545<class_1297,class_1297>> bientityCondition = data.get(Powers.BIENTITY_CONDITION);

        List<class_1297> others = entity.method_37908().method_8335(entity, entity.method_5829().method_1014(distance));
        class_1297 farthest = null;

        for (class_1297 other : others) {
            if (bientityCondition.test(new class_3545<>(entity, other)) && (farthest == null || entity.method_5739(other) > entity.method_5739(farthest))) farthest = other;
        }

        if (farthest != null) bientityAction.accept(new class_3545<>(entity, farthest));
    }

    public static ActionFactory<class_1297> createActionFactory () {
        return new ActionFactory<>(Powers.identifier("farthest_bientity"),
            new SerializableData()
            .add(Powers.DISTANCE, SerializableDataTypes.DOUBLE)
            .add(Powers.BIENTITY_ACTION, ApoliDataTypes.BIENTITY_ACTION)
            .add(Powers.BIENTITY_CONDITION, ApoliDataTypes.BIENTITY_CONDITION),
            ActOnFarthestEntityAction::action
        );
    }
}
