package com.provismet.proviorigins.actions;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3545;
import net.minecraft.class_6025;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;

public class ActOnOwnerAction {
    public static void action (SerializableData.Instance data, class_1297 entity) {
        final Consumer<class_3545<class_1297, class_1297>> bientityAction = data.get(Powers.BIENTITY_ACTION);
        final Predicate<class_3545<class_1297,class_1297>> bientityCondition = data.get(Powers.BIENTITY_CONDITION);

        if (entity instanceof class_6025 tameable && tameable.method_35057() != null) {
            class_3545<class_1297,class_1297> pair = new class_3545<class_1297,class_1297>(entity, tameable.method_35057());
            if (bientityCondition == null || bientityCondition.test(pair)) bientityAction.accept(pair);
        }
    }

    public static ActionFactory<class_1297> createActionFactory () {
        return new ActionFactory<>(Powers.identifier("owner_bientity"),
            new SerializableData()
            .add(Powers.BIENTITY_ACTION, ApoliDataTypes.BIENTITY_ACTION)
            .add(Powers.BIENTITY_CONDITION, ApoliDataTypes.BIENTITY_CONDITION, null),
            ActOnOwnerAction::action
        );
    }
}
