package com.provismet.proviorigins.actions;

import org.joml.Vector3f;

import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class ParticleRingAction {
    private static final String PARTICLE_LABEL = "particle";
    private static final String STEP_LABEL = "step_size";
    private static final String COUNT_LABEL = "count";
    private static final String DX_LABEL = "offset_x";
    private static final String DY_LABEL = "offset_y";
    private static final String DZ_LABEL = "offset_z";
    private static final String SPACE_LABEL = "space";
    private static final String SPEED_LABEL = "speed";
    private static final String GROUND_LABEL = "on_ground";

    public static void action (SerializableData.Instance data, class_1297 entity) {
        if (entity.method_37908().method_8608()) return;
        
        final float radius = data.getFloat(Powers.RADIUS);
        final float step = data.getFloat(STEP_LABEL) / class_3532.field_29848;
        final int count = data.getInt(COUNT_LABEL);
        final Space space = data.get(SPACE_LABEL);
        final double speed = data.getDouble(SPEED_LABEL);
        final boolean onGround = data.getBoolean(GROUND_LABEL);
        final class_2394 particles = data.get(PARTICLE_LABEL);

        Vector3f offsets = new Vector3f(data.getFloat(DX_LABEL), data.getFloat(DY_LABEL), data.getFloat(DZ_LABEL));
        space.toGlobal(offsets, entity);
        class_243 initial = entity.method_19538();
        initial = initial.method_1031(offsets.x, offsets.y, offsets.z);

        final float pitchRadians = (class_3532.field_29844 / 2) - (entity.method_36455() / class_3532.field_29848);
        final float yawRadians = -entity.method_5791() / class_3532.field_29848;

        class_3218 sWorld = (class_3218)entity.method_37908();
        for (float angle = 0; angle < 2 * class_3532.field_29844; angle += step) {
            class_243 point = initial.method_1031(radius * class_3532.method_15374(angle), 0.0, radius * class_3532.method_15362(angle));

            if (!onGround) {
                point = point.method_1020(initial);
                point = point.method_1037(pitchRadians);
                point = point.method_1024(yawRadians);
                point = point.method_1019(initial);
            }

            sWorld.method_14199(particles, point.field_1352, point.field_1351, point.field_1350, count, 0.0, 0.0, 0.0, speed);
        }
    }

    public static ActionFactory<class_1297> createActionFactory () {
        return new ActionFactory<>(Powers.identifier("particle_ring"),
            new SerializableData()
                .add(Powers.RADIUS, SerializableDataTypes.FLOAT)
                .add(STEP_LABEL, SerializableDataTypes.FLOAT)
                .add(COUNT_LABEL, SerializableDataTypes.INT, 1)
                .add(DX_LABEL, SerializableDataTypes.FLOAT, 0.0f)
                .add(DY_LABEL, SerializableDataTypes.FLOAT, 0.25f)
                .add(DZ_LABEL, SerializableDataTypes.FLOAT, 0.0f)
                .add(SPACE_LABEL, ApoliDataTypes.SPACE, Space.LOCAL)
                .add(SPEED_LABEL, SerializableDataTypes.DOUBLE, 0.0)
                .add(GROUND_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(PARTICLE_LABEL, SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE),
            ParticleRingAction::action);
    }
}
