package com.provismet.proviorigins.actions;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2694;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import com.provismet.proviorigins.ProviOriginsMain;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;

public class RaycastTeleportAction {
    private static final String DISTANCE_LABEL = "distance";
    private static final String DESTINATION_LABEL = "destination";
    private static final String ALLOW_WATER_LABEL = "allow_water";
    private static final String ALLOW_LAVA_LABEL = "allow_lava";
    private static final String SHAPE_TYPE_LABEL = "shape_type";
    private static final String FLUID_HANDLING_LABEL = "fluid_handling";
    private static final String SUCCESS_ACTION_LABEL = "success_action";
    private static final String FAILURE_ACTION_LABEL = "miss_action";

    private static final String DIRECT = "direct";
    private static final String ON_TOP = "on_top";

    public static void action (SerializableData.Instance data, class_1297 entity) {
        final double distance = data.getDouble(DISTANCE_LABEL);
        final String destination = data.getString(DESTINATION_LABEL);
        final boolean allowWater = data.getBoolean(ALLOW_WATER_LABEL);
        final boolean allowLava = data.getBoolean(ALLOW_LAVA_LABEL);
        final class_3960 shapeType = data.get(SHAPE_TYPE_LABEL);
        final class_242 fluidHandling = data.get(FLUID_HANDLING_LABEL);
        final Consumer<class_1297> successAction = data.get(SUCCESS_ACTION_LABEL);
        final Consumer<class_1297> failureAction = data.get(FAILURE_ACTION_LABEL);

        class_243 start = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        class_243 direction = entity.method_5828(1);
        class_243 end = start.method_1019(direction.method_1021(distance));

        class_3965 blockHit = entity.method_37908().method_17742(new class_3959(start, end, shapeType, fluidHandling, entity));
        if (blockHit.method_17783() != class_239.class_240.field_1333) {
            if (destination.equals(DIRECT)) {
                entity.field_6017 = 0f;
                entity.method_33574(blockHit.method_17784());
                if (successAction != null) successAction.accept(entity);
            }
            else if (destination.equals(ON_TOP)) {
                class_2694 upByOne = new class_2694(entity.method_37908(), blockHit.method_17777().method_10069(0, 1, 0), true);
                class_2694 upByTwo = new class_2694(entity.method_37908(), blockHit.method_17777().method_10069(0, 2, 0), true);

                if (isValid(upByOne, allowWater, allowLava) && isValid(upByTwo, allowWater, allowLava)) {
                    entity.field_6017 = 0f;
                    entity.method_5814(blockHit.method_17777().method_10263() + 0.5, blockHit.method_17777().method_10264() + 1, blockHit.method_17777().method_10260() + 0.5);
                    if (successAction != null) successAction.accept(entity);
                }
                else if (failureAction != null) failureAction.accept(entity);
            }
            else ProviOriginsMain.LOGGER.warn("Invalid teleport destination attempted.");
        }
        else if (failureAction != null) failureAction.accept(entity);
    }

    private static boolean isValid (class_2694 block, boolean allowWater, boolean allowLava) {
        return block.method_11681().method_26215() ||
            (allowWater && block.method_11679().method_8316(block.method_11683()).method_15767(class_3486.field_15517)) ||
            (allowLava && block.method_11679().method_8316(block.method_11683()).method_15767(class_3486.field_15518));
    }

    public static ActionFactory<class_1297> createActionFactory () {
        return new ActionFactory<>(Powers.identifier("raycast_teleport"), 
        new SerializableData()
            .add(DISTANCE_LABEL, SerializableDataTypes.DOUBLE)
            .add(DESTINATION_LABEL, SerializableDataTypes.STRING)
            .add(ALLOW_WATER_LABEL, SerializableDataTypes.BOOLEAN, false)
            .add(ALLOW_LAVA_LABEL, SerializableDataTypes.BOOLEAN, false)
            .add(SHAPE_TYPE_LABEL, SerializableDataType.enumValue(class_3960.class), class_3960.field_17559)
            .add(FLUID_HANDLING_LABEL, SerializableDataType.enumValue(class_242.class), class_242.field_1347)
            .add(SUCCESS_ACTION_LABEL, ApoliDataTypes.ENTITY_ACTION, null)
            .add(FAILURE_ACTION_LABEL, ApoliDataTypes.ENTITY_ACTION, null),
        RaycastTeleportAction::action);
    }
}
