package com.provismet.proviorigins.actions;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import com.provismet.proviorigins.ProviOriginsMain;
import com.provismet.proviorigins.content.entities.CloneEntity;
import com.provismet.proviorigins.content.registries.POEntities;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

public class SummonCloneAction {
    private static final String CAN_SIT_LABEL = "can_sit";
    private static final String CAN_ATTACK_LABEL = "can_attack";
    private static final String FOLLOW_OWNER_LABEL = "follow_owner";
    private static final String INHERIT_EQUIPMENT_LABEL = "inherit_equipment";
    private static final String INHERIT_ENCHANTMENTS_LABEL = "inherit_enchantments";
    
    public static void action (SerializableData.Instance data, class_1297 entity) {
        if (entity instanceof class_1657 player) {
            final boolean canSit = data.getBoolean(CAN_SIT_LABEL);
            final boolean canAttack = data.getBoolean(CAN_ATTACK_LABEL);
            final boolean followOwner = data.getBoolean(FOLLOW_OWNER_LABEL);
            final boolean inheritsEquipment = data.getBoolean(INHERIT_EQUIPMENT_LABEL);
            final boolean inheritsEnchantments = data.getBoolean(INHERIT_ENCHANTMENTS_LABEL);
            final Consumer<class_3545<class_1297, class_1297>> bientityAction = data.get(Powers.BIENTITY_ACTION);

            CloneEntity clone = summon(player, canSit, followOwner, canAttack, inheritsEquipment, inheritsEnchantments);
            if (bientityAction != null && clone != null) bientityAction.accept(new class_3545<>(player, clone)); 
        }
        else ProviOriginsMain.LOGGER.warn("Attempted to summon clone of invalid entity. Only Players are compatible with this action type.");
    }

    private static CloneEntity summon (class_1657 player, boolean canSit, boolean followOwner, boolean canAttack, boolean inheritsEquipment, boolean inheritsEnchantments) {
        if (player.method_37908() instanceof class_3218 serverWorld) {
            CloneEntity clone = new CloneEntity(POEntities.CLONE, serverWorld);
            clone.setCanSit(canSit);
            clone.setCanAttack(canAttack);
            clone.setFollowOwner(followOwner);

            clone.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_5791(), 0);

            clone.method_5943(serverWorld, serverWorld.method_8404(player.method_24515()), class_3730.field_16463, null, null);
            clone.method_5665(player.method_5477());
            clone.setOwnerUUID(player.method_5667());
            clone.method_5952(false);
            clone.method_5971();

            serverWorld.method_8649(clone);

            if (inheritsEquipment) {
                for (class_1304 slot : class_1304.values()) {
                    if (!player.method_6118(slot).method_7960()) {
                        clone.method_5946(slot, 0f);

                        class_1799 copy = new class_1799(player.method_6118(slot).method_7909(), player.method_6118(slot).method_7947());
                        if (inheritsEnchantments) {
                            class_1890.method_8214(class_1890.method_8222(player.method_6118(slot)), copy);
                        }
                        clone.method_5673(slot, copy);
                    }
                }
            }
            clone.updateWeaponGoals();
            return clone;
        }
        return null;
    }

    public static ActionFactory<class_1297> createActionFactory () {
        return new ActionFactory<>(Powers.identifier("summon_clone"),
            new SerializableData()
                .add(CAN_SIT_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(CAN_ATTACK_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(FOLLOW_OWNER_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(INHERIT_EQUIPMENT_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(INHERIT_ENCHANTMENTS_LABEL, SerializableDataTypes.BOOLEAN, true)
                .add(Powers.BIENTITY_ACTION, ApoliDataTypes.BIENTITY_ACTION, null),
            SummonCloneAction::action);
    }
}
