package com.provismet.proviorigins.actions.bientity;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

public class FireProjectileAction {
    private static final String SPEED_LABEL = "speed";
    private static final String ENTITY_LABEL = "entity_type";
    private static final String NBT_LABEL = "tag";
    private static final String DIVERGENCE_LABEL = "divergence";

    public static void action(SerializableData.Instance data, class_3545<class_1297,class_1297> pair) {
        if (pair.method_15442().method_37908().method_8608()) return;

        final class_1297 actor = pair.method_15442();
        final class_1297 target = pair.method_15441();
        final class_3218 serverWorld = (class_3218)actor.method_37908();

        final int count = data.getInt(Powers.COUNT);
        final float speed = data.getFloat(SPEED_LABEL);
        final float divergence = data.getFloat(DIVERGENCE_LABEL);
        final class_1299<?> entityType = data.get(ENTITY_LABEL);
        final class_2487 entityNbt = data.get(NBT_LABEL);

        final double dx = target.method_23317() - actor.method_23317();
        final double dy = target.method_23320() - actor.method_23320();
        final double dz = target.method_23321() - actor.method_23321();

        class_243 projectileDirection = (new class_243(dx, dy, dz)).method_1029();

        for (int i = 0; i < count; i++) {
            Optional<class_1297> opt$entityToSpawn = MiscUtil.getEntityWithPassengers(
                serverWorld,
                entityType,
                entityNbt,
                actor.method_19538().method_1031(0, actor.method_18381(actor.method_18376()), 0),
                actor.method_36454(),
                actor.method_36455()
            );
            if (opt$entityToSpawn.isEmpty()) return;

            class_1297 entityToSpawn = opt$entityToSpawn.get();

            if (entityToSpawn instanceof class_1676 projectileToSpawn) {
                if (projectileToSpawn instanceof class_1668 explosiveProjectileToSpawn) {
                    explosiveProjectileToSpawn.field_7601 = projectileDirection.field_1352 * speed;
                    explosiveProjectileToSpawn.field_7600 = projectileDirection.field_1351 * speed;
                    explosiveProjectileToSpawn.field_7599 = projectileDirection.field_1350 * speed;
                }

                projectileToSpawn.method_7432(actor);
                projectileToSpawn.method_7485(projectileDirection.field_1352, projectileDirection.field_1351, projectileDirection.field_1350, speed, divergence);
            }
            else {
                class_243 velocity = projectileDirection.method_1021((double)speed);
                entityToSpawn.method_18799(velocity);
            }
            
            serverWorld.method_30736(entityToSpawn);
            data.<Consumer<class_1297>>ifPresent(Powers.PROJECTILE_ACTION, projectileAction -> projectileAction.accept(entityToSpawn));
        }
    }

    public static ActionFactory<class_3545<class_1297,class_1297>> createBientityActionFactory () {
        return new ActionFactory<>(Powers.identifier("fire_projectile"),
            new SerializableData()
                .add(ENTITY_LABEL, SerializableDataTypes.ENTITY_TYPE)
                .add(DIVERGENCE_LABEL, SerializableDataTypes.FLOAT, 1F)
                .add(SPEED_LABEL, SerializableDataTypes.FLOAT, 1.5F)
                .add(Powers.COUNT, SerializableDataTypes.INT, 1)
                .add(NBT_LABEL, SerializableDataTypes.NBT, null)
                .add(Powers.PROJECTILE_ACTION, ApoliDataTypes.ENTITY_ACTION, null),
            FireProjectileAction::action
        );
    }

}
