package com.provismet.proviorigins.actions.bientity;

import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3545;

public class ParticleBeamAction {
    private static final String STEP_LABEL = "step";
    private static final String SPEED_LABEL = "speed";
    private static final String ACTOR_OFFSET_LABEL = "actor_offset_y";
    private static final String TARGET_OFFSET_LABEL = "target_offset_y";

    public static void action (SerializableData.Instance data, class_3545<class_1297, class_1297> bientity) {
        if (bientity.method_15442().method_37908().method_8608()) return;

        final class_1297 actor = bientity.method_15442();
        final class_1297 target = bientity.method_15441();

        class_3218 sWorld = (class_3218)actor.method_37908();

        final double step = data.getDouble(STEP_LABEL);
        final class_2394 particle = data.get(Powers.PARTICLE);
        final double speed = data.getDouble(SPEED_LABEL);
        final int count = data.getInt(Powers.COUNT);

        final double actor_y = data.getDouble(ACTOR_OFFSET_LABEL);
        final double target_y = data.getDouble(TARGET_OFFSET_LABEL);

        class_243 startPos = actor.method_19538().method_1031(0.0, actor_y, 0.0);
        class_243 currentPos = actor.method_19538().method_1031(0.0, actor_y, 0.0);
        class_243 destPos = target.method_19538().method_1031(0.0, target_y, 0.0);
        final double maxDistance = startPos.method_1022(destPos);

        class_243 eachStep = destPos.method_1020(currentPos).method_1029().method_1021(step);
        
        while (currentPos.method_1022(startPos) <= maxDistance) {
            sWorld.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, count, 0.0, 0.0, 0.0, speed);
            currentPos = currentPos.method_1019(eachStep);
        }
    }

    public static ActionFactory<class_3545<class_1297,class_1297>> createBientityActionFactory () {
        return new ActionFactory<>(Powers.identifier("particle_beam"),
            new SerializableData()
                .add(STEP_LABEL, SerializableDataTypes.DOUBLE)
                .add(Powers.PARTICLE, SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE)
                .add(SPEED_LABEL, SerializableDataTypes.DOUBLE, 0.0)
                .add(Powers.COUNT, SerializableDataTypes.INT, 1)
                .add(ACTOR_OFFSET_LABEL, SerializableDataTypes.DOUBLE, 0.0)
                .add(TARGET_OFFSET_LABEL, SerializableDataTypes.DOUBLE, 0.0),
            ParticleBeamAction::action);
    }
}
