package com.provismet.proviorigins.actions.bientity;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import net.minecraft.class_4081;
import net.minecraft.class_7923;
import com.google.common.collect.ImmutableMap;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

public class StatusTransferAction {
    private static final String STATUS_TYPE_LABEL = "status_types";
    private static final String EFFECTS_LABEL = "effects";
    private static final String CLEANSE_SELF_LABEL = "cleanse_self";
    private static final String AMPLIFIER_MODIFIER_LABEL = "amplifier_multiplier";
    private static final String DURATION_MODIFIER_LABEL = "duration_multiplier";

    private static final Map<class_4081, String> CATEGORIES = ImmutableMap.of(
        class_4081.field_18271, "beneficial",
        class_4081.field_18273, "neutral",
        class_4081.field_18272, "harmful"
    );

    public static void action (SerializableData.Instance data, class_3545<class_1297, class_1297> bientity) {
        if (!(bientity.method_15442() instanceof class_1309) || !(bientity.method_15441() instanceof class_1309) || bientity.method_15442().method_37908().method_8608()) return;
        
        final List<String> statusTypes = data.get(STATUS_TYPE_LABEL);
        final List<String> effectTypes = data.get(EFFECTS_LABEL);
        final boolean cleanse = data.getBoolean(CLEANSE_SELF_LABEL);
        final double amplifierMultiplier = data.getDouble(AMPLIFIER_MODIFIER_LABEL);
        final double durationMultiplier = data.getDouble(DURATION_MODIFIER_LABEL);

        class_1309 actor = (class_1309)bientity.method_15442();
        class_1309 target = (class_1309)bientity.method_15441();

        List<class_1293> effects = actor.method_6026().stream().filter(
            effect -> {
                if (statusTypes != null && statusTypes.contains(CATEGORIES.get(effect.method_5579().method_18792()))) return true;
                if (effectTypes != null && effectTypes.contains(class_7923.field_41174.method_10221(effect.method_5579()).toString())) return true;
                return false;
            }
        ).toList();
        
        for (class_1293 instance : effects) {
            if (cleanse) actor.method_6016(instance.method_5579());
            
            class_1293 newInstance = new class_1293(
                instance.method_5579(),
                (int)(instance.method_5584() * durationMultiplier),
                (int)(instance.method_5578() * amplifierMultiplier),
                instance.method_5591(),
                instance.method_5581(),
                instance.method_5592()
            );
            target.method_37222(newInstance, actor);
        }
    }

    public static ActionFactory<class_3545<class_1297, class_1297>> createBientityActionFactory () {
        return new ActionFactory<>(Powers.identifier("transfer_status"),
            new SerializableData()
                .add(STATUS_TYPE_LABEL, SerializableDataTypes.STRINGS, null)
                .add(EFFECTS_LABEL, SerializableDataTypes.STRINGS, null)
                .add(CLEANSE_SELF_LABEL, SerializableDataTypes.BOOLEAN)
                .add(AMPLIFIER_MODIFIER_LABEL, SerializableDataTypes.DOUBLE, 1.0)
                .add(DURATION_MODIFIER_LABEL, SerializableDataTypes.DOUBLE, 1.0),
            StatusTransferAction::action);
    }
}
