package com.provismet.proviorigins.conditions.bientity;

import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_3545;
import net.minecraft.class_6025;

public class FriendlyCondition {
    public static boolean condition (SerializableData.Instance data, class_3545<class_1297,class_1297> pair) {
        if (pair.method_15442() instanceof class_1309 actor && pair.method_15441() instanceof class_1309 target) {
            if (actor == target) return true;
            if (actor instanceof class_6025 tameable && tameable.method_35057() != null) {
                if (tameable.method_35057() == target) return true; // One owns the other.
                if (target instanceof class_6025 tameable2 && tameable2.method_35057() != null) { // These next two are symmetrical conditions.
                    if (tameable.method_35057() == tameable2.method_35057()) return true; // Same owner.
                    if (FriendlyCondition.condition(data, new class_3545<>(tameable.method_35057(), tameable2.method_35057()))) return true; // Owners are friendly to each other.
                }
                if (target == tameable.method_35057().method_6065() || target == tameable.method_35057().method_6052()) return false; // Help owner.
            }
            if (target instanceof class_6025 tameable && tameable.method_35057() != null) {
                if (tameable.method_35057() == actor) return true;
                if (actor == tameable.method_35057().method_6065() || actor == tameable.method_35057().method_6052()) return false; // Help owner.
            }
            if (actor.method_6065() == target || actor.method_6052() == target || target.method_6065() == actor || target.method_6052() == actor) return false; // In combat with each other.
            if (TeammateCondition.condition(data, pair)) return true;
            if ((actor instanceof class_1588) != (target instanceof class_1588)) return false; // Only one is hostile.
            return actor.method_5781() == null && target.method_5781() == null; // Neither is on a team.
        }
        return false;
    }

    public static ConditionFactory<class_3545<class_1297,class_1297>> getFactory () {
        return new ConditionFactory<>(Powers.identifier("friendly"), new SerializableData(), FriendlyCondition::condition);
    }
}
