package com.provismet.proviorigins.conditions.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_3545;
import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

public class EntityInRadiusCondition {
    private static final String INCLUDE_SELF = "include_self";

    public static boolean condition (SerializableData.Instance data, class_1297 entity) {
        final double radius = data.getDouble(Powers.RADIUS);
        final int compareTo = data.getInt(Powers.COMPARE_TO);
        final boolean includeSelf = data.getBoolean(INCLUDE_SELF);
        Predicate<class_1297> entityCondition = data.get(Powers.ENTITY_CONDITION);
        Predicate<class_3545<class_1297,class_1297>> bientityCondition = data.get(Powers.BIENTITY_CONDITION);
        Comparison comparison = data.get(Powers.COMPARISON);

        int count = 0;
        int stopAt = -1;
        List<class_1297> others = entity.method_37908().method_8335(entity, class_238.method_29968(entity.method_19538()).method_1014(radius));

        switch(comparison) {
            case EQUAL:
            case LESS_THAN_OR_EQUAL:
            case GREATER_THAN:
                stopAt = compareTo + 1;
                break;

            case LESS_THAN:
            case GREATER_THAN_OR_EQUAL:
                stopAt = compareTo;
                break;

            case NONE:
            case NOT_EQUAL:
                break;
        }

        if (includeSelf && entityCondition.test(entity)) {
            ++count;
            if (count == stopAt) return comparison.compare(count, compareTo);
        }

        for (class_1297 other : others) {
            if ((entityCondition == null || entityCondition.test(other)) && (bientityCondition == null || bientityCondition.test(new class_3545<class_1297,class_1297>(entity, other)))) {
                ++count;
                if (count == stopAt) break;
            }
        }

        return comparison.compare(count, compareTo);
    }

    public static ConditionFactory<class_1297> getFactory () {
        return new ConditionFactory<>(Powers.identifier("entity_in_radius"),
            new SerializableData()
                .add(Powers.ENTITY_CONDITION, ApoliDataTypes.ENTITY_CONDITION, null)
                .add(Powers.BIENTITY_CONDITION, ApoliDataTypes.BIENTITY_CONDITION, null)
                .add(Powers.RADIUS, SerializableDataTypes.DOUBLE)
                .add(INCLUDE_SELF, SerializableDataTypes.BOOLEAN, true)
                .add(Powers.COMPARISON, ApoliDataTypes.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL)
                .add(Powers.COMPARE_TO, SerializableDataTypes.INT, 1),
            EntityInRadiusCondition::condition);
    }
}
