package com.provismet.proviorigins.conditions.entity;

import com.provismet.proviorigins.powers.Powers;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;

public class VelocityYCondition {
    public static boolean condition (SerializableData.Instance data, class_1297 entity) {
        final double compareTo = data.getDouble(Powers.COMPARE_TO);
        Comparison comparison = data.get(Powers.COMPARISON);
        final double velocity = entity.method_18798().method_10214();

        return comparison.compare(velocity, compareTo);
    }

    public static ConditionFactory<class_1297> getFactory () {
        return new ConditionFactory<>(Powers.identifier("velocity_y"),
            new SerializableData()
                .add(Powers.COMPARISON, ApoliDataTypes.COMPARISON)
                .add(Powers.COMPARE_TO, SerializableDataTypes.DOUBLE),
            VelocityYCondition::condition
        );
    }
}
