package com.provismet.proviorigins.content.entities.renderers;

import com.provismet.proviorigins.content.entities.CloneEntity;
import com.provismet.proviorigins.content.entities.models.CloneEntityModel;
import com.provismet.proviorigins.content.registries.POModelLayerRegistry;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4506;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_572;
import net.minecraft.class_640;
import net.minecraft.class_909;
import net.minecraft.class_970;
import net.minecraft.class_973;

@Environment(EnvType.CLIENT)
public class CloneEntityRenderer<T extends CloneEntity> extends class_909<T, CloneEntityModel<T>> {
    private static final class_2960 DEFAULT_STEVE = new class_2960("minecraft", "textures/entity/steve.png");

    public CloneEntityRenderer (class_5618 context, boolean slimArms) {
        super(context, new CloneEntityModel<>(context.method_32167(slimArms ? POModelLayerRegistry.CLONE_SLIM_MODEL_LAYER : POModelLayerRegistry.CLONE_MODEL_LAYER), slimArms), 0.5f);

        class_572<T> inner = new class_572<>(context.method_32167(slimArms ? POModelLayerRegistry.CLONE_SLIM_INNER_LAYER : POModelLayerRegistry.CLONE_INNER_LAYER));
        class_572<T> outer = new class_572<>(context.method_32167(slimArms ? POModelLayerRegistry.CLONE_SLIM_OUTER_LAYER : POModelLayerRegistry.CLONE_OUTER_LAYER));
        this.method_4046(new class_970<>(this, inner, outer, context.method_48481()));
        this.method_4046(new class_973<>(context, this));
        this.method_4046(new class_4506<>(this));
    }

    @Override
    public class_2960 getTexture (T clone) {
        if (!clone.isOwned()) return DEFAULT_STEVE;
        class_640 entry = class_310.method_1551().method_1562().method_2871(clone.method_6139());
        
        if (entry == null) return DEFAULT_STEVE;
        else return entry.method_2968();
    }

    @Override
    public void render (T clone, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        if (clone.isSitting()) {
            matrixStack.method_22903();
            matrixStack.method_22904(0, -0.5, 0);
            super.method_4072(clone, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            matrixStack.method_22909();
        }
        else super.method_4072(clone, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    @Override
    protected void scale (T clone, class_4587 matrices, float amount) {
        final float AMOUNT = 0.9375f;
        matrices.method_22905(AMOUNT, AMOUNT, AMOUNT);
    }
}
