package com.provismet.proviorigins.content.particles;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class SoulCircleParticle extends class_4003 {
    private static final float STARTING_SCALE = 0.42f;
    private static final float ENDING_SCALE = 1f;

    private final float rotationSpeed;

    protected SoulCircleParticle(class_638 world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_3847 = 10;
        this.field_17867 = STARTING_SCALE;
        this.field_3841 = 0.8f;
        this.rotationSpeed = (float)Math.toRadians(field_3840.method_43056() ? 5.0 : -5.0);
    }

    @Override
    public void method_3070 () {
        super.method_3070();
        this.field_17867 = STARTING_SCALE + (ENDING_SCALE - STARTING_SCALE) * ((float)this.field_3866 / (float)this.field_3847);
        this.field_3857 = this.field_3839;
        this.field_3839 += this.rotationSpeed;
        this.field_3841 = 0.8f - 0.6f * ((float)this.field_3866 / (float)this.field_3847);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }
    
    @Environment(value=EnvType.CLIENT)
    public static class Factory implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public Factory (class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        public class_703 createParticle (class_2400 defaultParticleType, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            SoulCircleParticle particle = new SoulCircleParticle(world, x, y, z);
            particle.method_18140(this.spriteProvider);
            return particle;
        }
    }
}
