package com.provismet.proviorigins.content.particles.effects;

import org.joml.Vector3f;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.provismet.proviorigins.content.registries.POParticles;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_5744;
import net.minecraft.class_7923;

public class TelegraphParticleEffect implements class_2394 {
    protected final Vector3f colour;
    protected final float alpha;
    protected final float scale;
    protected final int duration;

    public TelegraphParticleEffect (Vector3f colour, float alpha, float scale, int duration) {
        this.colour = colour;
        this.alpha = alpha;
        this.scale = scale;
        this.duration = duration;
    }

    @SuppressWarnings("deprecation")
    public static final class_2394.class_2395<TelegraphParticleEffect> PARAMETERS_FACTORY = new class_2394.class_2395<TelegraphParticleEffect>() {
        @Override
        public TelegraphParticleEffect method_10296 (class_2396<TelegraphParticleEffect> particleType, StringReader stringReader) throws CommandSyntaxException {
            Vector3f vector3f = class_5744.method_33118(stringReader);
            stringReader.expect(' ');
            float alpha = stringReader.readFloat();
            stringReader.expect(' ');
            float scale = stringReader.readFloat();
            stringReader.expect(' ');
            int duration = stringReader.readInt();
            return new TelegraphParticleEffect(vector3f, alpha, scale, duration);
        }

        @Override
        public TelegraphParticleEffect method_10297 (class_2396<TelegraphParticleEffect> particleType, class_2540 packetByteBuf) {
            return new TelegraphParticleEffect (class_5744.method_33466(packetByteBuf), packetByteBuf.readFloat(), packetByteBuf.readFloat(), packetByteBuf.readInt());
        }
    };

    @Override
    public class_2396<TelegraphParticleEffect> method_10295 () {
        return POParticles.TELEGRAPH;
    }

    @Override
    public void method_10294 (class_2540 buffer) {
        buffer.writeFloat(this.colour.x());
        buffer.writeFloat(this.colour.y());
        buffer.writeFloat(this.colour.z());
        buffer.writeFloat(this.alpha);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.duration);
    }

    @Override
    public String method_10293 () {
        return String.format("%s %.2f %.2f %.2f %.2f %.2f %d", class_7923.field_41180.method_10221(this.method_10295()), this.colour.x(), this.colour.y(), this.colour.z(), this.alpha, this.scale, this.duration);
    }

    public Vector3f getColour () {
        return this.colour;
    }

    public float getAlpha () {
        return this.alpha;
    }

    public float getScale () {
        return this.scale;
    }

    public int getDuration () {
        return this.duration;
    }
}
