package com.provismet.proviorigins.content.registries;

import com.provismet.proviorigins.ProviOriginsMain;
import com.provismet.proviorigins.content.particles.effects.CrystalParticleEffect;
import com.provismet.proviorigins.content.particles.effects.FlowerParticleEffect;
import com.provismet.proviorigins.content.particles.effects.TelegraphParticleEffect;

import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_7923;

public class POParticles {
    public static final class_2400 LILY_PETAL = FabricParticleTypes.simple();
    public static final class_2400 SOUL_CIRCLE = FabricParticleTypes.simple(true);
    public static final class_2400 MAGIC_CIRCLE = FabricParticleTypes.simple();

    public static final class_2396<FlowerParticleEffect> FLOWER = FabricParticleTypes.complex(FlowerParticleEffect.PARAMETERS_FACTORY);
    public static final class_2396<TelegraphParticleEffect> TELEGRAPH = FabricParticleTypes.complex(true, TelegraphParticleEffect.PARAMETERS_FACTORY);
    public static final class_2396<CrystalParticleEffect> CRYSTAL = FabricParticleTypes.complex(true, CrystalParticleEffect.PARAMETERS_FACTORY);

    private static void registerSimple (class_2400 particle, String path) {
        class_2378.method_10230(class_7923.field_41180, ProviOriginsMain.identifier(path), particle);
    }

    private static <T extends class_2394> void registerComplex (class_2396<T> particle, String path) {
        class_2378.method_10230(class_7923.field_41180, ProviOriginsMain.identifier(path), particle);
    }

    public static void register () {
        registerSimple(LILY_PETAL, "lily_petal");
        registerSimple(SOUL_CIRCLE, "soul_circle");
        registerSimple(MAGIC_CIRCLE, "magic_circle");

        registerComplex(FLOWER, "flower");
        registerComplex(TELEGRAPH, "telegraph");
        registerComplex(CRYSTAL, "crystal");
    }
}
