package com.provismet.proviorigins.mixin;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_5715;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.provismet.proviorigins.powers.ActionOnDetectVibrationPower;
import com.provismet.proviorigins.powers.ModifyPassengerHeightPower;
import com.provismet.proviorigins.powers.OccludeVibrationsPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_1297.class)
public abstract class EntityMixin {
    @Shadow
    private class_4048 dimensions;

    // Action On Detect GameEvent Power
    @Inject(at=@At("HEAD"), method="updateEventHandler")
    public void addEventHandler (BiConsumer<class_5715<?>, class_3218> callback, CallbackInfo info) {
        if ((Object)this instanceof class_1309) {
            class_1309 living = (class_1309)(Object)this;

            if (!(living.method_37908() instanceof class_3218)) return;
            class_3218 world = (class_3218)living.method_37908();
    
            for (ActionOnDetectVibrationPower power : PowerHolderComponent.getPowers(living, ActionOnDetectVibrationPower.class)) {
                callback.accept(power.eventHandler, world);
            }
        }
    }

    // Adjust Passenger Height Power
    @Inject(at=@At("HEAD"), method="getMountedHeightOffset()D", cancellable=true)
    private void adjustHeight (CallbackInfoReturnable<Double> cir) {
        if ((class_1297)(Object)this instanceof class_1309 living) {
            List<ModifyPassengerHeightPower> powers = PowerHolderComponent.getPowers(living, ModifyPassengerHeightPower.class);

            if (!powers.isEmpty()) {
                double offsetAdd = powers.get(0).offsetAdditive;
                double offsetMul = powers.get(0).offsetMultiplicative;

                cir.setReturnValue(this.dimensions.field_18068 * 0.75 * offsetMul + offsetAdd);
            }
        }
    }

    // Occlude Vibration Power
    @Inject(at=@At("HEAD"), method="occludeVibrationSignals", cancellable=true)
    public void removeVibrations (CallbackInfoReturnable<Boolean> cir) {
        if ((Object)this instanceof class_1309 livingEntity) {
            if (!PowerHolderComponent.getPowers(livingEntity, OccludeVibrationsPower.class).isEmpty()) cir.setReturnValue(true);
        }
    }
}
