package com.provismet.proviorigins.mixin;

import java.util.Map;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.google.common.collect.ImmutableMap;
import com.provismet.proviorigins.content.entities.CloneEntity;
import com.provismet.proviorigins.content.entities.renderers.CloneEntityRenderer;
import com.provismet.proviorigins.content.registries.POEntities;

import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.impl.client.rendering.RegistrationHelperImpl;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_5599;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_759;
import net.minecraft.class_776;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;

@Mixin(class_898.class)
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    private @Final class_918 itemRenderer;

    @Shadow
    private @Final class_327 textRenderer;

    @Shadow
    private @Final class_5599 modelLoader;

    @Shadow
    private @Final class_759 heldItemRenderer;

    @Shadow
    private @Final class_776 blockRenderManager;

    @Unique
    private Map<String, class_897<CloneEntity>> cloneRenderers = ImmutableMap.of();

    @SuppressWarnings("unchecked")
    @Inject(at=@At("HEAD"), method="getRenderer", cancellable=true)
    public <T extends class_1297> void getCloneRenderer (T entity, CallbackInfoReturnable<class_897<? super T>> cir) {
        if (entity instanceof CloneEntity clone) {
            if (clone.isOwned()) {
                try {
                    String modelType = class_310.method_1551().method_1562().method_2871(clone.method_6139()).method_2977();
                    class_897<? super T> renderer = (class_897<? super T>) cloneRenderers.get(modelType);
                    cir.setReturnValue(renderer);
                }
                catch (NullPointerException e) {
                    cir.setReturnValue((class_897<? super T>)cloneRenderers.get("default"));
                }
            }
            else {
                cir.setReturnValue((class_897<? super T>)cloneRenderers.get("default"));
            }
        }
    }

    @Inject(at = @At("HEAD"), method="reload")
    public void reload (class_3300 manager, CallbackInfo info) {
        class_5618 context = new class_5618((class_898)(Object)this, this.itemRenderer, this.blockRenderManager, this.heldItemRenderer, manager, this.modelLoader, this.textRenderer);
        this.cloneRenderers = ImmutableMap.of(
            "default", createCloneEntityRenderer(context, false),
            "slim", createCloneEntityRenderer(context, true)
        );
    }

    @Unique
    @SuppressWarnings({"unchecked", "ConstantConditions", "rawtypes"})
    private static CloneEntityRenderer<CloneEntity> createCloneEntityRenderer (class_5618 context, boolean slimArms) {
        CloneEntityRenderer<CloneEntity> renderer = new CloneEntityRenderer<>(context, slimArms);
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)renderer;
        LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker()
            .registerRenderers(POEntities.CLONE, renderer, new RegistrationHelperImpl(accessor::invokeAddFeature), context);
        return renderer;
    }
}
