package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.provismet.proviorigins.powers.EmissivePower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(value = class_897.class, priority = 998)
public abstract class EntityRendererMixin {
    // Emissive Power
    @Inject(at=@At("HEAD"), method="getBlockLight", cancellable=true)
    public void makeEmissive (class_1297 entity, class_2338 pos, CallbackInfoReturnable<Integer> cir) {
        if (entity instanceof class_1309 living) {
            List<EmissivePower> emissives = PowerHolderComponent.getPowers(living, EmissivePower.class);
            if (!emissives.isEmpty()) {
                int max = emissives.get(0).light;
                for (EmissivePower p : emissives) {
                    if (p.light > max) max = p.light;
                }
                cir.setReturnValue(max);
            }
        }
    }
}
