package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_8103;
import com.provismet.proviorigins.content.registries.POStatusEffects;
import com.provismet.proviorigins.utility.tags.PODamageTypeTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.provismet.proviorigins.powers.EvadeProjectilesPower;
import com.provismet.proviorigins.powers.PreventBreathingPower;
import com.provismet.proviorigins.powers.PreventPortalsPower;
import com.provismet.proviorigins.powers.PreventPotionCloudPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract int getNextAirOnLand(int air);

    @Shadow
    public abstract int getNextAirUnderwater(int air);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    // Prevent Breathing Power
    private void applyAir (class_1282 source) {
        this.method_5855(this.getNextAirUnderwater(this.method_5669()) - this.getNextAirOnLand(0));
        if (this.method_5669() <= -20) {
            this.method_5855(0);

            this.method_5643(source, 2.0f);
        }
    }
    
    @Inject(at=@At("TAIL"), method="tick")
    private void tick (CallbackInfo info) {
        class_1309 living = (class_1309)(Object)this;
        List<PreventBreathingPower> noBreathes = PowerHolderComponent.getPowers(living, PreventBreathingPower.class);
        if (!noBreathes.isEmpty()) {
            if (!living.method_6059(class_1294.field_5923)) applyAir(noBreathes.get(0).getDamageSource());
            else {
                for (PreventBreathingPower powerInstance : noBreathes) {
                    if (!powerInstance.respectWaterBreathing) {
                        applyAir(powerInstance.getDamageSource());
                        break;
                    }
                }
            }
        }
    }
    
    // Prevent Potion Cloud Power
    @Inject(at=@At("RETURN"), method="isAffectedBySplashPotions", cancellable=true)
    private void canBeSplashed (CallbackInfoReturnable<Boolean> cir) {
        List<PreventPotionCloudPower> noPots = PowerHolderComponent.getPowers((class_1309)(Object)this, PreventPotionCloudPower.class);
        cir.setReturnValue(noPots.isEmpty());
    }

    // Untargetable Status Effect
    @Inject(at=@At("RETURN"), method="canTarget(Lnet/minecraft/entity/LivingEntity;)Z", cancellable=true)
    private void applyUntargetable (class_1309 target, CallbackInfoReturnable<Boolean> cir) {
        if (target.method_6059(POStatusEffects.UNTARGETABLE)) cir.setReturnValue(false);
    }

    // Apply double damage from sleep.
    @Inject(at=@At("RETURN"), method="modifyAppliedDamage", cancellable=true)
    private void applySleepDamage (class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        if (!source.method_48789(class_8103.field_42243)) {
            class_1309 livingEntity = (class_1309)(Object)this;

            if (livingEntity.method_6059(POStatusEffects.SLEEP)) {
                livingEntity.method_6016(POStatusEffects.SLEEP);
                cir.setReturnValue(cir.getReturnValue() * 2);
            }
        }
    }

    // Prevent sleeping entities from jumping.
    @Inject(at=@At("HEAD"), method="jump", cancellable=true)
    private void preventSleepJump (CallbackInfo info) {
        class_1309 livingEntity = (class_1309)(Object)this;
        if (livingEntity.method_6059(POStatusEffects.SLEEP)) info.cancel();
    }

    // Allow custom damage sources to disable shields when blocked.
    @Inject(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V", shift=At.Shift.AFTER), method="damage")
    private void disableShield (class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source.method_48789(PODamageTypeTags.DISABLES_SHIELDS) && (class_1309)(Object)this instanceof class_1657 player) {
            player.method_7284(true);
        }
    }

    // Force certain damage sources to always be blocked when the player has their shield raised.
    @Inject(at=@At("RETURN"), method="blockedByShield", cancellable=true)
    private void alwaysBlock (class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living = (class_1309)(Object)this;
        if (living.method_6039() && source.method_48789(PODamageTypeTags.ALWAYS_BLOCK)) cir.setReturnValue(true);
    }

    // Evade Projectile Power
    @Inject(at=@At("HEAD"), method="damage", cancellable=true)
    private void actOnProjectile (class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living = (class_1309)(Object)this;
        if (source.method_48789(class_8103.field_42247) && PowerHolderComponent.hasPower(living, EvadeProjectilesPower.class) && !living.method_6039()) {
            cir.setReturnValue(true); // This reports that damage was dealt, but prevents it from actually happening.
        }
    }

    @Inject(at=@At("RETURN"), method="canHaveStatusEffect", cancellable=true)
    private void cannotHaveSleepAndAlert (class_1293 effectInstance, CallbackInfoReturnable<Boolean> cir) {
        if (effectInstance.method_5579() == POStatusEffects.SLEEP &&
            ((class_1309)(Object)this).method_6059(POStatusEffects.ALERT)) cir.setReturnValue(false);
    }

    // Prevent Portal Powers
    @Inject(at=@At("RETURN"), method="canUsePortals", cancellable=true)
    private void cannotUsePortals (CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1309)(Object)this, PreventPortalsPower.class)) cir.setReturnValue(false);
    }
}
