package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_927;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.proviorigins.powers.IllusionPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_927.class)
public abstract class MobEntityRendererMixin extends class_922<class_1308, class_583<class_1308>> {
    protected MobEntityRendererMixin (class_5618 ctx, class_583<class_1308> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(at=@At("HEAD"), method="render(Lnet/minecraft/entity/mob/MobEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
    public void addMirrors (class_1308 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo info) {
        List<IllusionPower> mirrors = PowerHolderComponent.getPowers(livingEntity, IllusionPower.class);
        if (!mirrors.isEmpty()) {
            IllusionPower power = mirrors.get(0);
            class_243[] offsets = power.getOffsets(class_310.method_1551().field_1773.method_19418().method_19326());

            for (class_243 offset : offsets) {
                matrixStack.method_22903();
                matrixStack.method_22904(offset.method_10216(), offset.method_10214(), offset.method_10215());
                super.method_4054(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                matrixStack.method_22909();
            }
        }
    }
}
