package com.provismet.proviorigins.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.proviorigins.powers.EvadeProjectilesPower;

import io.github.apace100.apoli.component.PowerHolderComponent;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_3966;

@Mixin(class_1665.class)
public abstract class PersistentProjectileEntityMixin extends class_1676 {
    protected PersistentProjectileEntityMixin (class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }
    
    // Evade Projectile Power
    @Inject(at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z", shift=At.Shift.AFTER), method="onEntityHit", cancellable=true)
    private void ignoreProjectile (class_3966 hitResult, CallbackInfo info) {
        if (hitResult.method_17782() instanceof class_1309 living) {
            if (PowerHolderComponent.hasPower(living, EvadeProjectilesPower.class)) {
                info.cancel();
            }
        }
    }
}
