package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.provismet.proviorigins.content.registries.POStatusEffects;
import com.provismet.proviorigins.powers.ActionOnCriticalHitPower;
import com.provismet.proviorigins.powers.ActionOnGainExpPower;
import com.provismet.proviorigins.powers.ActionOnGainLevelPower;
import com.provismet.proviorigins.powers.PreventCriticalHitPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    // Action On Critical Hit
    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V", shift = At.Shift.AFTER), method = "attack(Lnet/minecraft/entity/Entity;)V")
    private void applyCritEffects (class_1297 target, CallbackInfo info) {
        class_1657 player = (class_1657)(Object)this;
        for (ActionOnCriticalHitPower critEffectPower : PowerHolderComponent.getPowers(player, ActionOnCriticalHitPower.class)) {
            critEffectPower.tryAction(target);
        }
    }
    
    // Prevent Critical Hit Power
    @ModifyVariable(at = @At("STORE"), method = "attack(Lnet/minecraft/entity/Entity;)V", ordinal = 2)
    private boolean preventCrits (boolean shouldCrit) {
        if (shouldCrit) {
            class_1657 player = (class_1657)(Object)this;
            if (PowerHolderComponent.hasPower(player, PreventCriticalHitPower.class)) return false;
        }
        return shouldCrit;
    }

    // Cannot break blocks when inflicted with Sleep.
    @Inject(at=@At("RETURN"), method="getBlockBreakingSpeed", cancellable=true)
    private void preventBlockBreakWhenSleeping (class_2680 block, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)(Object)this;
        if (player.method_6059(POStatusEffects.SLEEP)) cir.setReturnValue(0f);
    }

    // Action On Gain Level Power
    @Inject(at=@At("HEAD"), method="addExperienceLevels")
    private void executeOnLevel (int levels, CallbackInfo info) {
        List<ActionOnGainLevelPower> powers = PowerHolderComponent.getPowers((class_1657)(Object)this, ActionOnGainLevelPower.class);
        for (ActionOnGainLevelPower instance : powers) {
            instance.execute(levels);
        }
    }

    // Action On Gain Experience Power
    @Inject(at=@At("HEAD"), method="addExperience")
    private void executeOnExp (int experience, CallbackInfo info) {
        List<ActionOnGainExpPower> powers = PowerHolderComponent.getPowers((class_1657)(Object)this, ActionOnGainExpPower.class);
        for (ActionOnGainExpPower instance : powers) {
            instance.execute(experience);
        }
    }
}
