package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1007;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.proviorigins.powers.IllusionPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin extends class_922<class_742, class_591<class_742>> {
    protected PlayerEntityRendererMixin (class_5618 ctx, class_591<class_742> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(at=@At("TAIL"), method="render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
    public void addMirrors (class_742 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo info) {
        List<IllusionPower> mirrors = PowerHolderComponent.getPowers(livingEntity, IllusionPower.class);
        if (!mirrors.isEmpty()) {
            IllusionPower power = mirrors.get(0);
            class_243[] offsets = power.getOffsets(class_310.method_1551().field_1773.method_19418().method_19326());

            for (class_243 offset : offsets) {
                matrixStack.method_22903();
                matrixStack.method_22904(offset.method_10216(), offset.method_10214(), offset.method_10215());
                super.method_4054(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                matrixStack.method_22909();
            }
        }
    }

    @Inject(at=@At("HEAD"), method="render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
    public void displaceRider (class_742 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo info) {
        if (livingEntity.method_5765() && livingEntity.method_5854() instanceof class_1657 mountPlayer) {
            matrixStack.method_22904(0, -(0.222222 * livingEntity.method_17682()), 0);
        }
    }
}
