package com.provismet.proviorigins.mixin;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.proviorigins.powers.EvadeProjectilesPower;

import io.github.apace100.apoli.component.PowerHolderComponent;

@Mixin(class_1676.class)
public abstract class ProjectileEntityMixin extends class_1297 {
    protected ProjectileEntityMixin (class_1299<?> type, class_1937 world) {
        super(type, world);
    }
    
    @Inject(at=@At("HEAD"), method="onEntityHit")
    private void actionOnEvade (class_3966 hitResult, CallbackInfo info) {
        if (hitResult.method_17782() instanceof class_1309 living) {
            List<EvadeProjectilesPower> powers = PowerHolderComponent.getPowers(living, EvadeProjectilesPower.class);
            for (EvadeProjectilesPower powerInstance : powers) {
                powerInstance.executeAction((class_1676)(Object)this);
            }
        }
    }
}
