package com.provismet.proviorigins.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.provismet.proviorigins.content.registries.POStatusEffects;
import net.minecraft.class_1309;
import net.minecraft.class_4184;
import net.minecraft.class_761;

@Mixin(class_761.class)
public abstract class WorldRendererMixin {
    // Don't render sky if the player has Sleep.
    @Inject(at=@At("RETURN"), method="hasBlindnessOrDarkness", cancellable=true)
    private void checkForSleep (class_4184 camera, CallbackInfoReturnable<Boolean> cir) {
        if (camera.method_19331() instanceof class_1309 living) {
            if (living.method_6059(POStatusEffects.SLEEP)) cir.setReturnValue(true);
        }
    }
}
