package com.provismet.proviorigins.powers;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;

@SuppressWarnings("rawtypes")
public class ActionOnCriticalHitPower extends Power {
    private final Consumer<class_3545<class_1297,class_1297>> bientityAction;
    private final Predicate<class_3545<class_1297,class_1297>> bientityCondition;

    public ActionOnCriticalHitPower(PowerType<?> type, class_1309 entity, Consumer<class_3545<class_1297,class_1297>> bientityAction, Predicate<class_3545<class_1297,class_1297>> bientityCondition) {
        super(type, entity);
        this.bientityAction = bientityAction;
        this.bientityCondition = bientityCondition;
    }

    public void tryAction (class_1297 target) {
        if (bientityCondition == null || bientityCondition.test(new class_3545<>(this.entity, target))) {
            bientityAction.accept(new class_3545<>(this.entity, target));
        }
    }

    public static PowerFactory createPowerFactory () {
        return new PowerFactory<>(Powers.identifier("action_on_critical_hit"),
            new SerializableData()
                .add(Powers.BIENTITY_ACTION, ApoliDataTypes.BIENTITY_ACTION)
                .add(Powers.BIENTITY_CONDITION, ApoliDataTypes.BIENTITY_CONDITION, null),
                data -> (type, player) -> new ActionOnCriticalHitPower(type, player,
                    data.get(Powers.BIENTITY_ACTION),
                    data.get(Powers.BIENTITY_CONDITION)))
                .allowCondition();
    }
}
