package com.provismet.proviorigins.powers;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5712.class_7397;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_6862;
import net.minecraft.class_8514;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

@SuppressWarnings("rawtypes")
public class ActionOnDetectVibrationPower extends Power implements class_8514 {
    private static final String RANGE_LABEL = "range";
    private static final String GAME_EVENT_LABEL = "game_event_tag";
    private static final String MAX_DELAY_LABEL = "max_delay";
    private static final String MIN_DELAY_LABEL = "min_delay";

    private final int range;
    private final int maxDelay;
    private final int minDelay;
    private final class_6862<class_5712> acceptedEvents;
    private final Consumer<class_3545<class_1297, class_1297>> bientityAction;
    private final Predicate<class_3545<class_1297, class_1297>> bientityCondition;
    
    private final class_5719 callback;
    private final class_8515 listenerData;

    public final class_5715<class_8516> eventHandler;

    public ActionOnDetectVibrationPower(PowerType<?> type, class_1309 entity, int range, int minDelay, int maxDelay, class_6862<class_5712> acceptedEvents, Consumer<class_3545<class_1297, class_1297>> bientityAction, Predicate<class_3545<class_1297,class_1297>> bientityCondition) {
        super(type, entity);
        this.range = range;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.acceptedEvents = acceptedEvents;
        this.bientityAction = bientityAction;
        this.bientityCondition = bientityCondition;

        this.eventHandler = new class_5715<class_8516>(new class_8516(this));
        this.callback = new VibrationCallback();
        this.listenerData = new class_8515();

        this.setTicking();
    }

    private boolean shouldExecuteFor (class_1297 other) {
        if (other == this.entity || other == null) return false;
        else if (this.bientityCondition == null) return true;
        return this.bientityCondition.test(new class_3545<>(other, this.entity));
    }

    public void tick () {
        class_8517.method_51406(this.entity.method_37908(), this.listenerData, this.callback);
        if (this.listenerData.method_51395() > this.maxDelay) this.listenerData.method_51388(this.maxDelay);
    }

     @Override
    public class_8515 method_51298 () {
        return this.listenerData;
    }

    @Override
    public class_5719 method_51299() {
        return this.callback;
    }

    public static PowerFactory createPowerFactory () {
        return new PowerFactory<>(Powers.identifier("action_on_detect_vibration"),
            new SerializableData()
            .add(RANGE_LABEL, SerializableDataTypes.INT)
            .add(MIN_DELAY_LABEL, SerializableDataTypes.INT, 0)
            .add(MAX_DELAY_LABEL, SerializableDataTypes.INT, 0)
            .add(GAME_EVENT_LABEL, SerializableDataTypes.GAME_EVENT_TAG, class_5698.field_38079)
            .add(Powers.BIENTITY_ACTION, ApoliDataTypes.BIENTITY_ACTION)
            .add(Powers.BIENTITY_CONDITION, ApoliDataTypes.BIENTITY_CONDITION, null),
            data -> (type, player) -> new ActionOnDetectVibrationPower(type, player,
                data.getInt(RANGE_LABEL),
                data.getInt(MIN_DELAY_LABEL),
                data.getInt(MAX_DELAY_LABEL),
                data.get(GAME_EVENT_LABEL),
                data.get(Powers.BIENTITY_ACTION),
                data.get(Powers.BIENTITY_CONDITION)))
            .allowCondition();
    }

    class VibrationCallback implements class_8514.class_5719 {
        VibrationCallback () {}

        @Override
        public int method_51410 (float distance) {
            return Math.max(class_8514.class_5719.super.method_51410(distance), minDelay);
        }

        @Override
        public class_6862<class_5712> method_42210 () {
            return acceptedEvents;
        }

        @Override
        public int method_49797 () {
            return range;
        }

        @Override
        public class_5716 method_51300 () {
            return new class_5709(entity, entity.method_5751() / 2);
        }

        @Override
        public boolean method_32970 (class_3218 world, class_2338 pos, class_5712 event, class_7397 other) {
            return shouldExecuteFor(other.comp_713());
        }

        @Override
        public void method_32969 (class_3218 world, class_2338 pos, class_5712 event, class_1297 entity, class_1297 sourceEntity, float distance) {
            if (sourceEntity instanceof class_1309) {
                if (shouldExecuteFor(sourceEntity)) {
                    bientityAction.accept(new class_3545<>(sourceEntity, entity));
                }
            }
            else if (entity instanceof class_1309) {
                if (shouldExecuteFor(entity)) {
                    bientityAction.accept(new class_3545<>(entity, entity));
                }
            }
        }
    }
}
