package com.provismet.proviorigins.powers;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

@SuppressWarnings("rawtypes")
public class ActiveItemPower extends ActiveCooldownPower {
    private final Consumer<class_1297> entityAction;
    private final Predicate<class_1799> itemCondition;
    private final Predicate<class_1297> consumeCondition;
    private final int consumeAmount;
    private final boolean shouldSwingArm;

    public ActiveItemPower(PowerType<?> type, class_1309 entity, int cooldownDuration, HudRender hudRender, Consumer<class_1297> entityAction, Predicate<class_1799> itemCondition, Predicate<class_1297> consumeCondition, int consumeAmount, boolean shouldSwingArm) {
        super(type, entity, cooldownDuration, hudRender, entityAction);
        this.entityAction = entityAction;
        this.itemCondition = itemCondition;
        this.consumeCondition = consumeCondition;
        this.consumeAmount = consumeAmount;
        this.shouldSwingArm = shouldSwingArm;
    }

    @Override
    public void onUse () {
        if (this.canUse()) {
            class_1799 mainhand = this.entity.method_6118(class_1304.field_6173);
            class_1799 offhand = this.entity.method_6118(class_1304.field_6171);

            if (this.itemCondition.test(mainhand) && mainhand.method_7947() >= this.consumeAmount) {
                perform(class_1268.field_5808, mainhand);
            }
            else if (this.itemCondition.test(offhand) && offhand.method_7947() >= this.consumeAmount) {
                // If multiple of this power exist on one entity, avoid double using items.
                List<ActiveItemPower> activeItemPowers = PowerHolderComponent.getPowers(this.entity, ActiveItemPower.class);
                for (ActiveItemPower powerInstance : activeItemPowers) {
                    if (powerInstance.itemCondition.test(mainhand) && getKey().equals(powerInstance.getKey())) return;
                }
                perform(class_1268.field_5810, offhand);
            }
        }
    }

    private void perform (class_1268 hand, class_1799 itemStack) {
        if (this.shouldSwingArm) this.entity.method_23667(hand, true);
        if ((this.consumeCondition == null || this.consumeCondition.test(this.entity)) &&
            !(this.entity instanceof class_1657 && ((class_1657)this.entity).method_7337()))
                itemStack.method_7934(this.consumeAmount);
        use();
        this.entityAction.accept(this.entity);
    }
    
    public static PowerFactory createPowerFactory () {
        return new PowerFactory<>(Powers.identifier("active_item"),
        new SerializableData()
            .add(Powers.ENTITY_ACTION, ApoliDataTypes.ENTITY_ACTION)
            .add(Powers.ITEM_CONDITION, ApoliDataTypes.ITEM_CONDITION)
            .add("consume_condition", ApoliDataTypes.ENTITY_CONDITION, null)
            .add("consume_amount", SerializableDataTypes.INT, 1)
            .add("swing_arm", SerializableDataTypes.BOOLEAN, true)
            .add(Powers.COOLDOWN, SerializableDataTypes.INT, 1)
            .add(Powers.HUD_RENDER, ApoliDataTypes.HUD_RENDER, HudRender.DONT_RENDER)
            .add(Powers.KEY, ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, new Active.Key()),
            data -> (type, player) -> {
                ActiveItemPower power = new ActiveItemPower(type, player,
                    data.getInt(Powers.COOLDOWN),
                    data.get(Powers.HUD_RENDER),
                    data.get(Powers.ENTITY_ACTION),
                    data.get(Powers.ITEM_CONDITION),
                    data.get("consume_condition"),
                    data.getInt("consume_amount"),
                    data.getBoolean("swing_arm"));
                power.setKey(data.get(Powers.KEY));
                return power;
        }).allowCondition();
    }
}
