package com.provismet.proviorigins.powers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import com.provismet.lilylib.util.MoreMath.RightAngledTriangle;
import com.provismet.proviorigins.ProviOriginsMain;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;

@SuppressWarnings("rawtypes")
public class IllusionPower extends Power {
    private static final String DISTANCE_LABEL = "distance";
    private static final String COUNT_LABEL = "layers";
    private static final String MIRROR_TYPE_LABEL = "illusion_spread";

    private final double distance;
    private final int count;
    private final SpreadType spreadType;
    private final PowerType<?> resourceName;
    private Power resource;

    private final List<Polar> randomSpreads;

    public IllusionPower (PowerType<?> type, class_1309 entity, double distance, int count, String spreadType, PowerType<?> resourceType) {
        super(type, entity);
        this.distance = distance;
        this.count = count;
        this.resourceName = resourceType;
        this.randomSpreads = new ArrayList<>();

        SpreadType temp;
        try {
            temp = SpreadType.valueOf(spreadType.toUpperCase());
        }
        catch (Exception e) {
            temp = null;
            ProviOriginsMain.LOGGER.error(String.format("Power \"%s\" (skipping) contained illegal value for illusion_spread: \"%s\"", this.type.getIdentifier().toString(), spreadType));
        }
        this.spreadType = temp;
    }

    private void getResource () {
        if (this.resource == null && this.resourceName != null) {
            Power power = PowerHolderComponent.KEY.get(entity).getPower(this.resourceName);

            if (power instanceof VariableIntPower || power instanceof CooldownPower) this.resource = power;
            else this.resource = null;
        }
    }
    
    private double getDistance () {
        this.getResource();

        if (this.resource == null) {
            return this.distance;
        }
        else if (this.resource instanceof VariableIntPower rPower) {
            return this.distance * (double)rPower.getValue();
        }
        else if (this.resource instanceof CooldownPower cPower) {
            return this.distance * (double)cPower.getRemainingTicks();
        }
        else return this.distance;
    }

    public class_243[] getOffsets (class_243 viewer) {
        return switch (this.spreadType) {
            case LINE -> getOffsetsLine(viewer);
            case SPREAD -> getOffsetsSpread();
            default -> new class_243[0];
        };
    }

    public class_243[] getOffsetsLine (class_243 viewer) {
        class_243[] offsets = new class_243[this.count * 2];
        final double distanceModifier = this.getDistance();

        RightAngledTriangle triangle = new RightAngledTriangle(viewer, this.entity.method_19538());
        double cos = triangle.cosine();
        double sin = triangle.sine();

        for (int i = 0; i < this.count; ++i) {
            double distance = distanceModifier * (i + 1);
            offsets[i] = new class_243(distance * -cos, 0, distance * sin);
            offsets[i + this.count] = new class_243(distance * cos, 0, distance * -sin);
        }
        return offsets;
    }

    public class_243[] getOffsetsSpread () {
        if (this.randomSpreads.isEmpty()) {
            for (int i = 0; i < this.count; ++i) {
                this.randomSpreads.add(new Polar(
                    class_3532.method_15344(this.entity.method_6051(), 0, class_3532.field_29844 * 2),
                    class_3532.method_15366(this.entity.method_6051(), 0.2, 1.0)
                ));
            }
        }

        class_243[] offsets = new class_243[this.count];
        for (int i = 0; i < this.count; ++i) {
            float angle = this.randomSpreads.get(i).angle;
            double distance = this.randomSpreads.get(i).distance * this.getDistance();
            offsets[i] = new class_243(class_3532.method_15362(angle) * distance, 0, -class_3532.method_15374(angle) * distance);
        }

        return offsets;
    }

    @Override
    public boolean isActive() {
        boolean output = super.isActive();
        if (!output && !this.randomSpreads.isEmpty()) this.randomSpreads.clear();
        return output;
    }

    public static PowerFactory createPowerFactory () {
        return new PowerFactory<>(Powers.identifier("illusioner_mirror"),
            new SerializableData()
                .add(DISTANCE_LABEL, SerializableDataTypes.DOUBLE)
                .add(COUNT_LABEL, SerializableDataTypes.INT)
                .add(MIRROR_TYPE_LABEL, SerializableDataTypes.STRING)
                .add(Powers.RESOURCE, ApoliDataTypes.POWER_TYPE, null),
            data -> (type, player) -> new IllusionPower(type, player,
                data.getDouble(DISTANCE_LABEL),
                data.getInt(COUNT_LABEL),
                data.getString(MIRROR_TYPE_LABEL),
                data.get(Powers.RESOURCE)
            )
        ).allowCondition();
    }

    public enum SpreadType {
        LINE,
        SPREAD;
    }

    private record Polar(float angle, double distance) {}
}
