/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.mixin;

import com.provismet.proviorigins.content.registries.POStatusEffects;
import com.provismet.proviorigins.powers.EvadeProjectilesPower;
import com.provismet.proviorigins.powers.PreventBreathingPower;
import com.provismet.proviorigins.powers.PreventPortalsPower;
import com.provismet.proviorigins.powers.PreventPotionCloudPower;
import com.provismet.proviorigins.utility.tags.PODamageTypeTags;
import io.github.apace100.apoli.component.PowerHolderComponent;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    public abstract int method_6064(int var1);

    @Shadow
    public abstract int method_6130(int var1);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    private void applyAir(class_1282 source) {
        this.method_5855(this.method_6130(this.method_5669()) - this.method_6064(0));
        if (this.method_5669() <= -20) {
            this.method_5855(0);
            this.method_5643(source, 2.0f);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_1309 living = (class_1309)this;
        List noBreathes = PowerHolderComponent.getPowers((class_1297)living, PreventBreathingPower.class);
        if (!noBreathes.isEmpty()) {
            if (!living.method_6059(class_1294.field_5923)) {
                this.applyAir(((PreventBreathingPower)((Object)noBreathes.get(0))).getDamageSource());
            } else {
                for (PreventBreathingPower powerInstance : noBreathes) {
                    if (powerInstance.respectWaterBreathing) continue;
                    this.applyAir(powerInstance.getDamageSource());
                    break;
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isAffectedBySplashPotions"}, cancellable=true)
    private void canBeSplashed(CallbackInfoReturnable<Boolean> cir) {
        List noPots = PowerHolderComponent.getPowers((class_1297)((class_1309)this), PreventPotionCloudPower.class);
        cir.setReturnValue((Object)noPots.isEmpty());
    }

    @Inject(at={@At(value="RETURN")}, method={"canTarget(Lnet/minecraft/entity/LivingEntity;)Z"}, cancellable=true)
    private void applyUntargetable(class_1309 target, CallbackInfoReturnable<Boolean> cir) {
        if (target.method_6059(POStatusEffects.UNTARGETABLE)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"modifyAppliedDamage"}, cancellable=true)
    private void applySleepDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 livingEntity;
        if (!source.method_48789(class_8103.field_42243) && (livingEntity = (class_1309)this).method_6059(POStatusEffects.SLEEP)) {
            livingEntity.method_6016(POStatusEffects.SLEEP);
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * 2.0f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jump"}, cancellable=true)
    private void preventSleepJump(CallbackInfo info) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_6059(POStatusEffects.SLEEP)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V", shift=At.Shift.AFTER)}, method={"damage"})
    private void disableShield(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        class_1309 class_13092;
        if (source.method_48789(PODamageTypeTags.DISABLES_SHIELDS) && (class_13092 = (class_1309)this) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            player.method_7284(true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"blockedByShield"}, cancellable=true)
    private void alwaysBlock(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living = (class_1309)this;
        if (living.method_6039() && source.method_48789(PODamageTypeTags.ALWAYS_BLOCK)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    private void actOnProjectile(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living = (class_1309)this;
        if (source.method_48789(class_8103.field_42247) && PowerHolderComponent.hasPower((class_1297)living, EvadeProjectilesPower.class) && !living.method_6039()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void cannotHaveSleepAndAlert(class_1293 effectInstance, CallbackInfoReturnable<Boolean> cir) {
        if (effectInstance.method_5579() == POStatusEffects.SLEEP && ((class_1309)this).method_6059(POStatusEffects.ALERT)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canUsePortals"}, cancellable=true)
    private void cannotUsePortals(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1297)((class_1309)this), PreventPortalsPower.class)) {
            cir.setReturnValue((Object)false);
        }
    }
}

