/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.mixin;

import com.provismet.proviorigins.content.registries.POStatusEffects;
import com.provismet.proviorigins.powers.ActionOnCriticalHitPower;
import com.provismet.proviorigins.powers.ActionOnGainExpPower;
import com.provismet.proviorigins.powers.ActionOnGainLevelPower;
import com.provismet.proviorigins.powers.PreventCriticalHitPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V", shift=At.Shift.AFTER)}, method={"attack(Lnet/minecraft/entity/Entity;)V"})
    private void applyCritEffects(class_1297 target, CallbackInfo info) {
        class_1657 player = (class_1657)this;
        for (ActionOnCriticalHitPower critEffectPower : PowerHolderComponent.getPowers((class_1297)player, ActionOnCriticalHitPower.class)) {
            critEffectPower.tryAction(target);
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"attack(Lnet/minecraft/entity/Entity;)V"}, ordinal=2)
    private boolean preventCrits(boolean shouldCrit) {
        class_1657 player;
        if (shouldCrit && PowerHolderComponent.hasPower((class_1297)(player = (class_1657)this), PreventCriticalHitPower.class)) {
            return false;
        }
        return shouldCrit;
    }

    @Inject(at={@At(value="RETURN")}, method={"getBlockBreakingSpeed"}, cancellable=true)
    private void preventBlockBreakWhenSleeping(class_2680 block, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        if (player.method_6059(POStatusEffects.SLEEP)) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addExperienceLevels"})
    private void executeOnLevel(int levels, CallbackInfo info) {
        List powers = PowerHolderComponent.getPowers((class_1297)((class_1657)this), ActionOnGainLevelPower.class);
        for (ActionOnGainLevelPower instance : powers) {
            instance.execute(levels);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addExperience"})
    private void executeOnExp(int experience, CallbackInfo info) {
        List powers = PowerHolderComponent.getPowers((class_1297)((class_1657)this), ActionOnGainExpPower.class);
        for (ActionOnGainExpPower instance : powers) {
            instance.execute(experience);
        }
    }
}

