/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.powers;

import com.provismet.lilylib.util.MoreMath;
import com.provismet.proviorigins.ProviOriginsMain;
import com.provismet.proviorigins.powers.Powers;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class IllusionPower
extends Power {
    private static final String DISTANCE_LABEL = "distance";
    private static final String COUNT_LABEL = "layers";
    private static final String MIRROR_TYPE_LABEL = "illusion_spread";
    private final double distance;
    private final int count;
    private final SpreadType spreadType;
    private final PowerType<?> resourceName;
    private Power resource;
    private final List<Polar> randomSpreads;

    public IllusionPower(PowerType<?> type, class_1309 entity, double distance, int count, String spreadType, PowerType<?> resourceType) {
        super(type, entity);
        SpreadType temp;
        this.distance = distance;
        this.count = count;
        this.resourceName = resourceType;
        this.randomSpreads = new ArrayList<Polar>();
        try {
            temp = SpreadType.valueOf(spreadType.toUpperCase());
        }
        catch (Exception e) {
            temp = null;
            ProviOriginsMain.LOGGER.error(String.format("Power \"%s\" (skipping) contained illegal value for illusion_spread: \"%s\"", this.type.getIdentifier().toString(), spreadType));
        }
        this.spreadType = temp;
    }

    private void getResource() {
        if (this.resource == null && this.resourceName != null) {
            Power power = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.entity)).getPower(this.resourceName);
            this.resource = power instanceof VariableIntPower || power instanceof CooldownPower ? power : null;
        }
    }

    private double getDistance() {
        this.getResource();
        if (this.resource == null) {
            return this.distance;
        }
        Power power = this.resource;
        if (power instanceof VariableIntPower) {
            VariableIntPower rPower = (VariableIntPower)power;
            return this.distance * (double)rPower.getValue();
        }
        power = this.resource;
        if (power instanceof CooldownPower) {
            CooldownPower cPower = (CooldownPower)power;
            return this.distance * (double)cPower.getRemainingTicks();
        }
        return this.distance;
    }

    public class_243[] getOffsets(class_243 viewer) {
        return switch (this.spreadType.ordinal()) {
            case 0 -> this.getOffsetsLine(viewer);
            case 1 -> this.getOffsetsSpread();
            default -> new class_243[]{};
        };
    }

    public class_243[] getOffsetsLine(class_243 viewer) {
        class_243[] offsets = new class_243[this.count * 2];
        double distanceModifier = this.getDistance();
        MoreMath.RightAngledTriangle triangle = new MoreMath.RightAngledTriangle(viewer, this.entity.method_19538());
        double cos = triangle.cosine();
        double sin = triangle.sine();
        for (int i = 0; i < this.count; ++i) {
            double distance = distanceModifier * (double)(i + 1);
            offsets[i] = new class_243(distance * -cos, 0.0, distance * sin);
            offsets[i + this.count] = new class_243(distance * cos, 0.0, distance * -sin);
        }
        return offsets;
    }

    public class_243[] getOffsetsSpread() {
        if (this.randomSpreads.isEmpty()) {
            for (int i = 0; i < this.count; ++i) {
                this.randomSpreads.add(new Polar(class_3532.method_15344((class_5819)this.entity.method_6051(), (float)0.0f, (float)((float)Math.PI * 2)), class_3532.method_15366((class_5819)this.entity.method_6051(), (double)0.2, (double)1.0)));
            }
        }
        class_243[] offsets = new class_243[this.count];
        for (int i = 0; i < this.count; ++i) {
            float angle = this.randomSpreads.get((int)i).angle;
            double distance = this.randomSpreads.get((int)i).distance * this.getDistance();
            offsets[i] = new class_243((double)class_3532.method_15362((float)angle) * distance, 0.0, (double)(-class_3532.method_15374((float)angle)) * distance);
        }
        return offsets;
    }

    public boolean isActive() {
        boolean output = super.isActive();
        if (!output && !this.randomSpreads.isEmpty()) {
            this.randomSpreads.clear();
        }
        return output;
    }

    public static PowerFactory createPowerFactory() {
        return new PowerFactory(Powers.identifier("illusioner_mirror"), new SerializableData().add(DISTANCE_LABEL, SerializableDataTypes.DOUBLE).add(COUNT_LABEL, SerializableDataTypes.INT).add(MIRROR_TYPE_LABEL, SerializableDataTypes.STRING).add("resource", ApoliDataTypes.POWER_TYPE, null), data -> (type, player) -> new IllusionPower((PowerType<?>)type, (class_1309)player, data.getDouble(DISTANCE_LABEL), data.getInt(COUNT_LABEL), data.getString(MIRROR_TYPE_LABEL), (PowerType<?>)((PowerType)data.get("resource")))).allowCondition();
    }

    public static enum SpreadType {
        LINE,
        SPREAD;

    }

    private record Polar(float angle, double distance) {
    }
}

