/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe.condition;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class EventConditionRegistry {
    private static final BiMap<class_2960, Class<? extends EventCondition>> TYPES_BY_CLASS = HashBiMap.create();
    private static final BiMap<class_2960, EventConditionType<? extends EventCondition>> TYPES = HashBiMap.create();
    public static final Codec<EventConditionType<? extends EventCondition>> BY_NAME_CODEC = EventConditionRegistry.byNameCodec();
    public static final Codec<EventCondition> CODEC = BY_NAME_CODEC.dispatch(it -> EventConditionRegistry.getType(it.getClass()), EventConditionType::mapCodec);
    public static final Codec<List<EventCondition>> LIST_CODEC = CODEC.listOf();

    private static Codec<EventConditionType<? extends EventCondition>> byNameCodec() {
        return class_2960.field_25139.flatXmap(identifier -> Optional.ofNullable(EventConditionRegistry.getType(identifier)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown event condition: " + String.valueOf(identifier))), type -> DataResult.success((Object)type.identifier));
    }

    public static <T extends EventCondition> void registerCondition(class_2960 identifier, Class<T> clazz, MapCodec<T> codec, Function<class_2540, T> networkDeserializer) {
        if (TYPES_BY_CLASS.containsKey((Object)identifier)) {
            throw new IllegalArgumentException("Condition with identifier " + String.valueOf(identifier) + " is already registered");
        }
        TYPES.put((Object)identifier, new EventConditionType<T>(identifier, codec, networkDeserializer));
        TYPES_BY_CLASS.put((Object)identifier, clazz);
    }

    public static class_2960 getIdentifier(Class<? extends EventCondition> conditionClass) {
        return (class_2960)TYPES_BY_CLASS.inverse().get(conditionClass);
    }

    public static <T extends EventCondition> EventConditionType<T> getType(class_2960 identifier) {
        return (EventConditionType)TYPES.get((Object)identifier);
    }

    public static <T extends EventCondition> EventConditionType<T> getType(Class<T> clazz) {
        return EventConditionRegistry.getType(EventConditionRegistry.getIdentifier(clazz));
    }

    public static EventCondition conditionFromNetwork(class_2540 buf) {
        class_2960 identifier = buf.method_10810();
        EventConditionType type = EventConditionRegistry.getType(identifier);
        if (type == null) {
            throw new IllegalArgumentException("Unknown event condition " + String.valueOf(identifier));
        }
        return type.networkDeserializer.apply(buf);
    }

    public static void conditionToNetwork(class_2540 buf, EventCondition condition) {
        class_2960 identifier = EventConditionRegistry.getIdentifier(condition.getClass());
        if (identifier == null) {
            throw new IllegalArgumentException("Event condition " + String.valueOf(condition.getClass()) + " is not registered");
        }
        buf.method_10812(identifier);
        condition.toNetwork(buf);
    }

    public record EventConditionType<T extends EventCondition>(class_2960 identifier, MapCodec<T> mapCodec, Function<class_2540, ? extends EventCondition> networkDeserializer) {
        public Codec<T> codec() {
            return this.mapCodec.codec();
        }
    }
}

