/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5699;

public class ChunkLimitManager
extends class_18 {
    private static final String DATA_NAME = "littlejoys";
    private static final Codec<ChunkLimitManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53703((Codec)Codec.STRING.xmap(Long::parseLong, String::valueOf), (Codec)Codec.INT).fieldOf("FishingSpotChunks").forGetter(ChunkLimitManager::getFishingSpotCounts), (App)class_5699.method_53703((Codec)Codec.STRING.xmap(Long::parseLong, String::valueOf), (Codec)Codec.INT).fieldOf("DigSpotChunks").forGetter(ChunkLimitManager::getDigSpotCounts)).apply((Applicative)instance, ChunkLimitManager::new));
    private static final class_10741<ChunkLimitManager> TYPE = new class_10741("littlejoys", context -> new ChunkLimitManager(Map.of(), Map.of()), ctx -> CODEC, null);
    private final Map<Long, Integer> fishingSpotCounts = new HashMap<Long, Integer>();
    private final Map<Long, Integer> digSpotCounts = new HashMap<Long, Integer>();

    public ChunkLimitManager(Map<Long, Integer> fishingSpotCounts, Map<Long, Integer> digSpotCounts) {
        this.fishingSpotCounts.putAll(fishingSpotCounts);
        this.digSpotCounts.putAll(digSpotCounts);
    }

    public static ChunkLimitManager get(class_3218 level) {
        return (ChunkLimitManager)level.method_17983().method_17924(TYPE);
    }

    private Map<Long, Integer> getFishingSpotCounts() {
        return this.fishingSpotCounts;
    }

    private Map<Long, Integer> getDigSpotCounts() {
        return this.digSpotCounts;
    }

    public int getTotalFishingSpotsInChunk(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        return this.fishingSpotCounts.getOrDefault(chunkKey, 0);
    }

    public int getTotalDigSpotsInChunk(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        return this.digSpotCounts.getOrDefault(chunkKey, 0);
    }

    public void trackFishingSpot(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        Integer currentCount = this.fishingSpotCounts.getOrDefault(chunkKey, 0);
        this.fishingSpotCounts.put(chunkKey, currentCount + 1);
        this.method_80();
    }

    public void trackDigSpot(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        Integer currentCount = this.digSpotCounts.getOrDefault(chunkKey, 0);
        this.digSpotCounts.put(chunkKey, currentCount + 1);
        this.method_80();
    }
}

